/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.service;

import CH.ifa.draw.figures.TextFigure;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.fa.FADrawing;
import de.renew.fa.figures.EndDecoration;
import de.renew.fa.figures.FAArcConnection;
import de.renew.fa.figures.FAStateFigure;
import de.renew.fa.figures.StartDecoration;
import de.renew.fa.figures.StartEndDecoration;
import java.io.OutputStream;
import java.io.PrintWriter;

public class JflapFileCreator {
    protected String _fileName;

    public static void writeToJflap(OutputStream stream, Drawing drawing) {
        if (drawing instanceof FADrawing) {
            FADrawing faDrawing = (FADrawing)drawing;
            JflapFileCreator.export(stream, (Drawing)faDrawing);
        }
    }

    public static void export(OutputStream strem, Drawing drawing) {
        if (drawing instanceof FADrawing) {
            Figure figure;
            FADrawing fad = (FADrawing)drawing;
            PrintWriter pw = new PrintWriter(strem);
            pw.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><!--Created with JFLAP 6.0.--><structure>\n");
            pw.write("  <type>fa</type>\n");
            pw.write("  <automaton>\n");
            pw.write("      <!--The list of states.-->\n");
            FigureEnumeration figures = fad.figures();
            while (figures.hasMoreElements()) {
                figure = (Figure)figures.nextElement();
                if (!(figure instanceof FAStateFigure)) continue;
                FAStateFigure state = (FAStateFigure)figure;
                pw.write("      <state id=\"" + state.getID() + "\" name=\"" + (state.children().hasMoreElements() ? ((TextFigure)state.children().nextElement()).getText() : "") + "\">\n");
                pw.write("          <x>" + state.displayBox().x + ".0</x>\n");
                pw.write("          <y>" + state.displayBox().y + ".0</y>\n");
                if (state.getDecoration() instanceof StartDecoration) {
                    pw.write("          <initial/>\n");
                }
                if (state.getDecoration() instanceof EndDecoration) {
                    pw.write("          <final/>\n");
                }
                if (state.getDecoration() instanceof StartEndDecoration) {
                    pw.write("          <initial/>\n");
                    pw.write("          <final/>\n");
                }
                pw.write("      </state>\n");
            }
            pw.write("      <!--The list of transitions.-->\n");
            figures = fad.figures();
            while (figures.hasMoreElements()) {
                String[] strings;
                figure = (Figure)figures.nextElement();
                if (!(figure instanceof FAArcConnection)) continue;
                FAArcConnection arc = (FAArcConnection)figure;
                String s = arc.children().hasMoreElements() ? ((TextFigure)arc.children().nextElement()).getText() : "";
                for (String string : strings = s.split(",")) {
                    pw.write("      <transition>\n");
                    pw.write("          <from>" + ((FAStateFigure)arc.startFigure()).getID() + "</from>\n");
                    pw.write("          <to>" + ((FAStateFigure)arc.endFigure()).getID() + "</to>\n");
                    if (string.equals("\u03b5")) {
                        pw.write("          <read/>\n");
                    } else {
                        pw.write("          <read>" + string + "</read>\n");
                    }
                    pw.write("      </transition>\n");
                }
            }
            pw.write("  </automaton>\n");
            pw.write("</structure>\n");
            pw.close();
        }
    }
}

