/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.mappings;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.automatalib.commons.util.mappings.MapMapping;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.commons.util.mappings.MappingComposition;
import net.automatalib.commons.util.mappings.StringIndexMapping;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Mappings {
    private static final Mapping<?, ?> NULL_MAPPING = elem -> null;
    private static final Mapping<?, ?> IDENTITY_MAPPING = elem -> elem;
    private static final Mapping<?, String> TOSTRING_MAPPING = String::valueOf;

    private Mappings() {
    }

    public static <D, R> Mapping<D, R> nullMapping() {
        return NULL_MAPPING;
    }

    public static <T> Mapping<T, T> identity() {
        return IDENTITY_MAPPING;
    }

    public static <D> Mapping<D, String> toStringMapping() {
        return TOSTRING_MAPPING;
    }

    public static <S, T extends S> Mapping<T, S> upcast() {
        return IDENTITY_MAPPING;
    }

    public static <D, I, R> Mapping<D, R> compose(Mapping<D, ? extends I> first, Mapping<? super I, R> second) {
        return new MappingComposition<D, I, R>(first, second);
    }

    public static <D, R> Collection<R> apply(Mapping<? super D, R> mapping, Collection<? extends D> coll) {
        return Collections2.transform(coll, mapping::get);
    }

    public static <D, R> Iterator<R> apply(Mapping<? super D, R> mapping, Iterator<? extends D> baseIt) {
        return Iterators.transform(baseIt, mapping::get);
    }

    public static <D, R> List<R> apply(Mapping<? super D, R> mapping, List<? extends D> list) {
        return Lists.transform(list, mapping::get);
    }

    public static <D, R> Iterable<R> apply(Mapping<? super D, R> mapping, Iterable<? extends D> it) {
        return Iterables.transform(it, mapping::get);
    }

    public static <D> D idGet(Mapping<D, D> mapping, D key) {
        return Mappings.safeGet(mapping, key, key);
    }

    public static <D, R> R safeGet(@Nullable Mapping<? super D, ? extends R> mapping, D key, R fallback) {
        if (mapping == null) {
            return fallback;
        }
        R val = mapping.get(key);
        if (val == null) {
            return fallback;
        }
        return val;
    }

    public static <D, R> @Nullable R nullGet(@Nullable Mapping<? super D, ? extends R> mapping, D key) {
        return Mappings.safeGet(mapping, key, null);
    }

    public static <D, R> Mapping<D, R> fromMap(Map<D, R> map) {
        return new MapMapping<D, R>(map);
    }

    public static Mapping<String, Long> stringToIndex() {
        return StringIndexMapping::stringToIndex;
    }

    public static Mapping<Long, String> indexToString() {
        return StringIndexMapping::indexToString;
    }
}

