/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts.comp;

import net.automatalib.commons.util.Pair;
import net.automatalib.ts.DeterministicTransitionSystem;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DTSComposition<S1, S2, I, T1, T2, TS1 extends DeterministicTransitionSystem<S1, I, T1>, TS2 extends DeterministicTransitionSystem<S2, I, T2>>
implements DeterministicTransitionSystem<Pair<S1, S2>, I, Pair<T1, T2>> {
    protected final TS1 ts1;
    protected final TS2 ts2;
    protected final boolean allowPartial;

    public DTSComposition(TS1 ts1, TS2 ts2) {
        this(ts1, ts2, false);
    }

    public DTSComposition(TS1 ts1, TS2 ts2, boolean allowPartial) {
        this.ts1 = ts1;
        this.ts2 = ts2;
        this.allowPartial = allowPartial;
    }

    public TS1 getFirstTS() {
        return this.ts1;
    }

    public TS2 getSecondTS() {
        return this.ts2;
    }

    @Override
    public Pair<S1, S2> getInitialState() {
        return Pair.of(this.ts1.getInitialState(), this.ts2.getInitialState());
    }

    @Override
    public @Nullable Pair<T1, T2> getTransition(Pair<@Nullable S1, @Nullable S2> state, I input) {
        Object t2;
        Object t1;
        S1 s1 = state.getFirst();
        Object T1 = t1 = s1 == null ? null : (Object)this.ts1.getTransition(s1, input);
        if (t1 == null && !this.allowPartial) {
            return null;
        }
        S2 s2 = state.getSecond();
        Object T2 = t2 = s2 == null ? null : (Object)this.ts2.getTransition(s2, input);
        if (t2 == null && !this.allowPartial) {
            return null;
        }
        return t1 == null && t2 == null ? null : Pair.of(t1, t2);
    }

    @Override
    public Pair<S1, S2> getSuccessor(Pair<@Nullable T1, @Nullable T2> transition) {
        T1 t1 = transition.getFirst();
        T2 t2 = transition.getSecond();
        return Pair.of(t1 == null ? null : (Object)this.ts1.getSuccessor(t1), t2 == null ? null : (Object)this.ts2.getSuccessor(t2));
    }
}

