/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.BidirectionalGraph;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.IndefiniteGraph;
import net.automatalib.graphs.concepts.EdgeWeights;
import net.automatalib.util.graphs.Path;
import net.automatalib.util.graphs.ShortestPaths;
import net.automatalib.util.graphs.apsp.APSPResult;
import net.automatalib.util.graphs.apsp.FloydWarshallAPSP;
import net.automatalib.util.graphs.scc.SCCListener;
import net.automatalib.util.graphs.scc.SCCs;
import net.automatalib.util.graphs.sssp.DijkstraSSSP;
import net.automatalib.util.graphs.sssp.SSSPResult;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Graphs {
    public static final float INVALID_DISTANCE = Float.NEGATIVE_INFINITY;

    private Graphs() {
    }

    public static <N, E> Mapping<N, @Nullable Collection<E>> incomingEdges(Graph<N, E> graph) {
        if (graph instanceof BidirectionalGraph) {
            BidirectionalGraph bdGraph = (BidirectionalGraph)graph;
            return bdGraph::getIncomingEdges;
        }
        MutableMapping<N, @Nullable V> inEdgesMapping = graph.createStaticNodeMapping();
        for (Object node : graph) {
            Collection outEdges = graph.getOutgoingEdges(node);
            for (Object e : outEdges) {
                Object tgt = graph.getTarget(e);
                ArrayList inEdges = (ArrayList)inEdgesMapping.get(tgt);
                if (inEdges == null) {
                    inEdges = new ArrayList();
                    inEdgesMapping.put(tgt, inEdges);
                }
                inEdges.add(e);
            }
        }
        return inEdgesMapping;
    }

    public static <N, E> @Nullable Path<N, E> findShortestPath(IndefiniteGraph<N, E> graph, int limit, N start, Collection<? extends N> targets) {
        return ShortestPaths.shortestPath(graph, start, limit, targets);
    }

    public static <N, E> @Nullable Path<N, E> findShortestPath(IndefiniteGraph<N, E> graph, int limit, N start, Predicate<? super N> targetPred) {
        return ShortestPaths.shortestPath(graph, start, limit, targetPred);
    }

    public static <N, E> List<N> toNodeList(List<E> edgeList, Graph<N, E> graph, N init) {
        ArrayList result = new ArrayList(edgeList.size() + 1);
        result.add(init);
        for (E edge : edgeList) {
            Object tgt = graph.getTarget(edge);
            result.add(tgt);
        }
        return result;
    }

    public static <N, E> APSPResult<N, E> findAPSP(Graph<N, E> graph, EdgeWeights<E> edgeWeights) {
        return FloydWarshallAPSP.findAPSP(graph, edgeWeights);
    }

    public static <N, E> SSSPResult<N, E> findSSSP(Graph<N, E> graph, N init, EdgeWeights<E> edgeWeights) {
        return DijkstraSSSP.findSSSP(graph, init, edgeWeights);
    }

    public static <N, E> List<List<N>> collectSCCs(Graph<N, E> graph) {
        return SCCs.collectSCCs(graph);
    }

    public static <N, E> void findSCCs(Graph<N, E> graph, SCCListener<N> sccListener) {
        SCCs.findSCCs(graph, sccListener);
    }
}

