/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization.dot;

import com.google.common.io.CharStreams;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.visualization.dot.DOT;
import net.automatalib.visualization.dot.DOTMisc;
import net.automatalib.visualization.dot.ImageComponent;

public class DOTComponent
extends ImageComponent {
    private static final long serialVersionUID = 1L;
    private final String dot;
    private final Action saveDotAction;

    public DOTComponent(Reader dotReader) throws IOException {
        StringBuilder sb = new StringBuilder();
        CharStreams.copy(dotReader, sb);
        final String dot = sb.toString();
        BufferedImage img = DOT.renderDOTImage(dot);
        super.setImage(img);
        this.dot = dot;
        this.saveDotAction = new AbstractAction("Save DOT"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser saveDlg = new JFileChooser();
                saveDlg.setFileFilter(DOTMisc.DOT_FILTER);
                int result = saveDlg.showSaveDialog(DOTComponent.this);
                if (result != 0) {
                    return;
                }
                try (Writer w = IOUtil.asBufferedUTF8Writer(saveDlg.getSelectedFile());){
                    w.write(dot);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(DOTComponent.this, "Could not save DOT file: " + ex.getMessage(), "Cannot save DOT", 0);
                }
            }
        };
    }

    @Override
    public void listActions(List<Action> actions) {
        super.listActions(actions);
        actions.add(this.saveDotAction);
    }

    public String getDot() {
        return this.dot;
    }

    public Action getSaveDotAction() {
        return this.saveDotAction;
    }
}

