/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words.impl;

import java.util.Arrays;
import net.automatalib.words.impl.ArrayAlphabet;

public class EnumAlphabet<E extends Enum<E>>
extends ArrayAlphabet<E> {
    public EnumAlphabet(Class<E> enumClazz, boolean withNull) {
        super(EnumAlphabet.extractEnumValues(enumClazz, withNull));
    }

    private static <E> E[] extractEnumValues(Class<E> enumClazz, boolean withNull) {
        E[] enumValues = enumClazz.getEnumConstants();
        if (enumValues == null) {
            throw new IllegalArgumentException("Class " + enumClazz.getName() + " is not an enumeration class!");
        }
        if (!withNull) {
            return enumValues;
        }
        return Arrays.copyOf(enumValues, enumValues.length + 1);
    }

    @Override
    public int getSymbolIndex(E symbol) {
        if (symbol == null) {
            int lastIdx = ((Enum[])this.symbols).length - 1;
            if (((Enum[])this.symbols)[lastIdx] == null) {
                return lastIdx;
            }
            throw new IllegalArgumentException("No such symbol: null");
        }
        return ((Enum)symbol).ordinal();
    }

    @Override
    public boolean containsSymbol(E symbol) {
        if (symbol == null) {
            return ((Enum[])this.symbols)[((Enum[])this.symbols).length - 1] == null;
        }
        int index = ((Enum)symbol).ordinal();
        return index < ((Enum[])this.symbols).length && ((Enum[])this.symbols)[index] == symbol;
    }

    @Override
    public int compare(E o1, E o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        return ((Enum)o1).compareTo(o2);
    }
}

