/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.CollectionEnumeration;
import de.renew.util.Types;
import de.uni_hamburg.fs.BasicType;
import de.uni_hamburg.fs.EmptyEnumeration;
import de.uni_hamburg.fs.JavaType;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.NoFeatureNode;
import de.uni_hamburg.fs.NoSuchFeatureException;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.ParsedType;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.UnificationFailure;

public abstract class JavaClassType
implements JavaType,
ParsedType {
    private Class<?> _type;
    private boolean _isPrimitive;

    protected JavaClassType() {
    }

    protected JavaClassType(Class<?> type) {
        this.setJavaClass(type);
    }

    void setJavaClass(Class<?> type) {
        this._isPrimitive = type.isPrimitive();
        this._type = this._isPrimitive ? Types.objectify(type) : type;
    }

    public Class<?> getJavaClass() {
        if (this._isPrimitive) {
            return Types.typify(this._type);
        }
        return this._type;
    }

    @Override
    public boolean isApprop(Name featureName) {
        return false;
    }

    @Override
    public Type appropType(Name featureName) throws NoSuchFeatureException {
        throw new NoSuchFeatureException(featureName, this);
    }

    @Override
    public CollectionEnumeration appropFeatureNames() {
        return EmptyEnumeration.INSTANCE;
    }

    @Override
    public Node newNode() {
        return new NoFeatureNode(this);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof JavaClassType) {
            return ((JavaClassType)that).getJavaClass() == this.getJavaClass();
        }
        return false;
    }

    public int hashCode() {
        return this.getJavaClass().hashCode();
    }

    @Override
    public ParsedType unite(ParsedType that) throws UnificationFailure {
        if (that.equals(ParsedType.PARSED_TOP)) {
            return this;
        }
        if (that instanceof BasicType) {
            return (BasicType)this.unify((BasicType)that);
        }
        throw new UnificationFailure();
    }

    @Override
    public Type asType() throws UnificationFailure {
        return this;
    }
}

