/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.Set;
import collections.UpdatableSet;
import de.renew.util.ClassSource;
import de.renew.util.StringUtil;
import de.renew.util.Types;
import de.uni_hamburg.fs.BeanFeature;
import de.uni_hamburg.fs.Concept;
import de.uni_hamburg.fs.ConceptEnumeration;
import de.uni_hamburg.fs.FieldFeature;
import de.uni_hamburg.fs.IndexFeature;
import de.uni_hamburg.fs.JavaFeature;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.NoSuchFeatureException;
import de.uni_hamburg.fs.OrderedTable;
import de.uni_hamburg.fs.ParsedType;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.TypeSystem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class JavaConcept
implements Concept {
    public static final Logger LOGGER = Logger.getLogger(JavaConcept.class);
    public static final Object[] NOPARAM = new Object[0];
    public static final Class<?>[] NOPARAMDEF = new Class[0];
    static final Object[] FIRSTINDEX = new Object[]{0};
    private static final UpdatableSet DONT_USE = new HashedSet();
    private static final String VISIBILITY_CHARS = "-#+";
    private Class<?> _javaClass;
    private String _javaClassName;
    private transient OrderedTable _approp = new OrderedTable();
    private boolean _isClass;
    private boolean _canInstantiate = false;

    JavaConcept(Class<?> javaClass) {
        if (Enumeration.class.isAssignableFrom(javaClass)) {
            throw new RuntimeException("Someone tried to build a JavaConcept for " + javaClass.getName());
        }
        int mods = javaClass.getModifiers();
        this._javaClass = javaClass;
        this._javaClassName = javaClass.getName();
        boolean bl = this._isClass = !Modifier.isAbstract(mods) && !Modifier.isInterface(mods);
        if (!Modifier.isPublic(mods)) {
            this._javaClassName = this._javaClassName + "(n/a)";
        } else {
            this.findFeatures(new StringBuffer());
        }
    }

    @Override
    public String getName() {
        int dotpos = this._javaClassName.lastIndexOf(".");
        if (dotpos == -1) {
            return this._javaClassName;
        }
        return this._javaClassName.substring(dotpos + 1);
    }

    @Override
    public String getNamespace() {
        return JavaConcept.getNamespace(this._javaClassName);
    }

    public static String getNamespace(String javaClassName) {
        int dotpos = javaClassName.lastIndexOf(".");
        if (dotpos == -1) {
            return javaClassName;
        }
        return javaClassName.substring(0, dotpos);
    }

    @Override
    public String getFullName() {
        return this._javaClassName;
    }

    public Class<?> getJavaClass() {
        return this._javaClass;
    }

    public boolean canInstantiate() {
        return this._canInstantiate;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.findFeatures(new StringBuffer());
    }

    JavaFeature getJavaFeature(Name featureName) {
        return (JavaFeature)this._approp.at(featureName);
    }

    @Override
    public boolean isa(Concept that) {
        if (that instanceof JavaConcept) {
            Class<?> thatJavaClass = ((JavaConcept)that).getJavaClass();
            return thatJavaClass.isAssignableFrom(this.getJavaClass());
        }
        return false;
    }

    @Override
    public boolean isNotA(Concept that) {
        if (Modifier.isFinal(this.getJavaClass().getModifiers())) {
            return true;
        }
        if (that instanceof JavaConcept) {
            Class<?> thatJavaClass = ((JavaConcept)that).getJavaClass();
            if (Modifier.isFinal(thatJavaClass.getModifiers())) {
                return true;
            }
            if (thatJavaClass.isInterface()) {
                return false;
            }
        }
        return !this.getJavaClass().isInterface();
    }

    @Override
    public boolean isExtensional() {
        return false;
    }

    @Override
    public ConceptEnumeration extensionalSuperconcepts() {
        return null;
    }

    @Override
    public boolean isApprop(Name feature) {
        return this._approp.includesKey(feature);
    }

    private Class<?> getClassOf(Name feature) {
        if (this._isClass) {
            return this.getJavaFeature(feature).getJavaClass();
        }
        return (Class)this._approp.at(feature);
    }

    @Override
    public ParsedType appropParsedType(Name featureName) throws NoSuchFeatureException {
        return TypeSystem.instance().getParsedType(this.getClassOf(featureName));
    }

    @Override
    public Type appropType(Name featureName) throws NoSuchFeatureException {
        return TypeSystem.instance().getType(this.getClassOf(featureName));
    }

    @Override
    public CollectionEnumeration appropFeatureNames() {
        return this._approp.keys();
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.getJavaClass().hashCode();
    }

    public boolean equals(Object that) {
        if (that instanceof JavaConcept) {
            return ((JavaConcept)that).getJavaClass().equals(this.getJavaClass());
        }
        return false;
    }

    public Set findFeatures(StringBuffer umlDescr) {
        return this.findFeatures(umlDescr, JavaConcept.getWellKnownPackages(this._javaClass));
    }

    public Set findFeatures(StringBuffer umlDescr, String[] wellKnown) {
        try {
            this._javaClass.getConstructor(NOPARAMDEF);
            this._canInstantiate = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JavaConcept.addClassDescr(this._javaClass, umlDescr);
        if (this._javaClass == String.class) {
            return new HashedSet();
        }
        this.addFieldFeatures(umlDescr, wellKnown);
        return this.addMethodFeatures(umlDescr, wellKnown);
    }

    private static void addClassDescr(Class<?> clazz, StringBuffer umlDescr) {
        int mods;
        if (clazz.isInterface()) {
            umlDescr.append("\u00abinterface\u00bb\n");
        }
        if (!Modifier.isPublic(mods = clazz.getModifiers())) {
            JavaConcept.addModifierDescr(mods, umlDescr, false);
        }
        umlDescr.append(Types.typeToString(clazz, null));
        umlDescr.append("\n");
    }

    public static int getVisibilityLevel(int mods) {
        if (Modifier.isPublic(mods)) {
            return 2;
        }
        if (Modifier.isPrivate(mods)) {
            return 0;
        }
        return 1;
    }

    public static int getVisibilityLevel(char visibility) {
        return VISIBILITY_CHARS.indexOf(visibility);
    }

    private static void addModifierDescr(int mods, StringBuffer umlDescr, boolean showPublic) {
        if (Modifier.isStatic(mods)) {
            umlDescr.append("_");
        } else if (Modifier.isAbstract(mods) && !Modifier.isInterface(mods)) {
            umlDescr.append("\\");
        }
        if (showPublic || !Modifier.isPublic(mods)) {
            umlDescr.append(VISIBILITY_CHARS.charAt(JavaConcept.getVisibilityLevel(mods))).append(" ");
        }
    }

    public static void loadClass(Class<?> javaClass) {
        if (!javaClass.isPrimitive() && !javaClass.isArray()) {
            try {
                ClassSource.classForName((String)javaClass.getName());
            }
            catch (ClassNotFoundException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (LinkageError e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void addFieldFeatures(StringBuffer umlDescr, String[] wellKnown) {
        Field[] field = this._javaClass.getFields();
        Arrays.sort(field, (f1, f2) -> f1.toString().compareTo(f2.toString()));
        for (int i = 0; i < field.length; ++i) {
            int mod = field[i].getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isVolatile(mod)) continue;
            Class<?> featureType = field[i].getType();
            JavaConcept.loadClass(featureType);
            if (Enumeration.class.isAssignableFrom(featureType)) continue;
            Name featureName = new Name(field[i].getName());
            Object javaType = this._isClass ? new FieldFeature(field[i]) : featureType;
            try {
                this._javaClass.getDeclaredField(featureName._name);
                umlDescr.append(featureName).append(": ").append(Types.typeToString(featureType, (String[])wellKnown)).append("\n");
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this._approp.putAt(featureName, javaType);
        }
    }

    public static String toFeatureName(String getMethodName) {
        int startIndex = 0;
        if (getMethodName.startsWith("get")) {
            startIndex = 3;
        } else if (getMethodName.startsWith("is")) {
            startIndex = 2;
        }
        if (startIndex > 0 && !StringUtil.isUpperCaseAt((String)getMethodName, (int)startIndex)) {
            startIndex = 0;
        }
        if (StringUtil.isUpperCaseAt((String)(getMethodName = getMethodName.substring(startIndex)), (int)1)) {
            return getMethodName;
        }
        return StringUtil.firstToLowerCase((String)getMethodName);
    }

    private boolean isDeclared(Class<?> clazz, Method method) {
        try {
            clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    private Set addMethodFeatures(StringBuffer umlDescr, String[] wellKnown) {
        HashedSet usedMethods = new HashedSet();
        Method[] method = this._javaClass.getMethods();
        Arrays.sort(method, (m1, m2) -> m1.toString().compareTo(m2.toString()));
        for (int i = 0; i < method.length; ++i) {
            boolean canWrite;
            Class<?> featureType = method[i].getReturnType();
            if (!Modifier.isPublic(featureType.getModifiers())) continue;
            int mod = method[i].getModifiers();
            String featureStr = method[i].getName();
            Class<?>[] paramType = method[i].getParameterTypes();
            int noParams = paramType.length;
            if (Modifier.isStatic(mod) || featureType == Void.TYPE || noParams > 1 || DONT_USE.includes((Object)featureStr)) continue;
            featureStr = JavaConcept.toFeatureName(featureStr);
            Name featureName = new Name(featureStr);
            JavaConcept.loadClass(featureType);
            Object javaType = null;
            if (noParams == 1 && paramType[0] == Integer.TYPE) {
                javaType = this.findIndexFeature(method[i], featureStr, featureType, (UpdatableSet)usedMethods);
                featureName = new Name(featureStr + "s");
            } else if (noParams == 0) {
                if (!this._isClass) {
                    javaType = featureType;
                } else {
                    Method setMethod = this.findSetMethod(featureStr, featureType);
                    if (setMethod != null) {
                        usedMethods.include((Object)setMethod);
                    }
                    javaType = new BeanFeature(method[i], setMethod);
                }
                usedMethods.include((Object)method[i]);
            }
            if (javaType == null) continue;
            boolean bl = canWrite = this._isClass && ((JavaFeature)javaType).canSet();
            if (!canWrite && this._approp.includesKey(featureName)) continue;
            this._approp.putAt(featureName, javaType);
            featureType = this._isClass ? ((JavaFeature)javaType).getJavaClass() : (Class<?>)javaType;
            if (!this.isDeclared(this._javaClass, method[i])) continue;
            umlDescr.append(featureName).append(": ").append(Types.typeToString(featureType, (String[])wellKnown));
            if (this._isClass && !canWrite) {
                umlDescr.append(" {readOnly}");
            }
            umlDescr.append("\n");
        }
        return usedMethods;
    }

    public static String[] getWellKnownPackages(Class<?> clazz) {
        return new String[]{"java.lang", Types.getPackageName(clazz)};
    }

    public String getClassDescription() {
        return this.getClassDescription(JavaConcept.getWellKnownPackages(this._javaClass));
    }

    public String getClassDescription(String[] wellKnown) {
        this._approp = new OrderedTable();
        StringBuffer umlDescr = new StringBuffer();
        Set usedMethods = this.findFeatures(umlDescr, wellKnown);
        umlDescr.append("\n");
        Method[] method = this._javaClass.getDeclaredMethods();
        Arrays.sort(method, (m1, m2) -> m1.toString().compareTo(m2.toString()));
        for (int i = 0; i < method.length; ++i) {
            int mods = method[i].getModifiers();
            if (!Modifier.isPublic(mods) || Modifier.isStatic(mods) || usedMethods.includes((Object)method[i])) continue;
            JavaConcept.addMethodDescription(method[i], umlDescr, wellKnown);
        }
        return umlDescr.toString();
    }

    public static String getImplementationDescription(Class<?> clazz, int visibilityLevel) {
        return JavaConcept.getImplementationDescription(clazz, visibilityLevel, JavaConcept.getWellKnownPackages(clazz));
    }

    public static String getImplementationDescription(Class<?> clazz, int visibilityLevel, String[] wellKnown) {
        StringBuffer umlDescr = new StringBuffer();
        JavaConcept.addClassDescr(clazz, umlDescr);
        Field[] field = clazz.getDeclaredFields();
        Arrays.sort(field, (f1, f2) -> f1.toString().compareTo(f2.toString()));
        for (int i = 0; i < field.length; ++i) {
            int mods;
            if (field[i].getName().indexOf("$") >= 0 || JavaConcept.getVisibilityLevel(mods = field[i].getModifiers()) < visibilityLevel) continue;
            JavaConcept.addModifierDescr(mods, umlDescr, true);
            umlDescr.append(field[i].getName()).append(": ").append(Types.typeToString(field[i].getType(), (String[])wellKnown));
            if (Modifier.isFinal(mods)) {
                umlDescr.append(" {frozen}");
            }
            umlDescr.append("\n");
        }
        umlDescr.append("\n");
        Method[] method = clazz.getDeclaredMethods();
        Arrays.sort(method, (m1, m2) -> m1.toString().compareTo(m2.toString()));
        for (int i = 0; i < method.length; ++i) {
            int mods;
            if (method[i].getName().indexOf("$") >= 0 || JavaConcept.getVisibilityLevel(mods = method[i].getModifiers()) < visibilityLevel) continue;
            if (!clazz.isInterface()) {
                JavaConcept.addModifierDescr(mods, umlDescr, true);
            }
            JavaConcept.addMethodDescription(method[i], umlDescr, wellKnown);
        }
        return umlDescr.toString();
    }

    private static void addMethodDescription(Method method, StringBuffer umlDescr, String[] wellKnown) {
        umlDescr.append(method.getName()).append("(");
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int p = 0; p < paramTypes.length; ++p) {
            umlDescr.append(Types.typeToString(paramTypes[p], (String[])wellKnown));
            if (p >= paramTypes.length - 1) continue;
            umlDescr.append(", ");
        }
        umlDescr.append(")");
        Class<?> returnType = method.getReturnType();
        if (returnType != Void.TYPE) {
            umlDescr.append(": ").append(Types.typeToString(returnType, (String[])wellKnown));
        }
        umlDescr.append("\n");
    }

    private Method findSetMethod(String featureStr, Class<?> featureType) {
        Method setMethod = null;
        if (this._canInstantiate) {
            String setStr = "set" + StringUtil.firstToUpperCase((String)featureStr);
            try {
                setMethod = this._javaClass.getMethod(setStr, featureType);
                if (Modifier.isStatic(setMethod.getModifiers()) || setMethod.getReturnType() != Void.TYPE) {
                    setMethod = null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return setMethod;
    }

    private Object findIndexFeature(Method getMethod, String featureStr, Class<?> featureType, UpdatableSet usedMethods) {
        Object javaType;
        block9: {
            if (featureType.isPrimitive()) {
                return null;
            }
            javaType = null;
            try {
                Method countMethod = this._javaClass.getMethod(getMethod.getName() + "Count", NOPARAMDEF);
                if (Modifier.isStatic(countMethod.getModifiers()) || countMethod.getReturnType() != Integer.TYPE) break block9;
                usedMethods.include((Object)countMethod);
                usedMethods.include((Object)getMethod);
                if (this._isClass) {
                    Method addMethod = null;
                    try {
                        addMethod = this._javaClass.getMethod("add" + StringUtil.firstToUpperCase((String)featureStr), featureType);
                    }
                    catch (Throwable t1) {
                        try {
                            addMethod = this._javaClass.getMethod("add", featureType);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (addMethod != null) {
                        usedMethods.include(addMethod);
                    }
                    javaType = new IndexFeature(countMethod, getMethod, addMethod);
                    break block9;
                }
                javaType = Array.newInstance(featureType, 0).getClass();
            }
            catch (Throwable t0) {
                javaType = null;
            }
        }
        return javaType;
    }

    static {
        DONT_USE.include((Object)"getClass");
        DONT_USE.include((Object)"hashCode");
        DONT_USE.include((Object)"clone");
        DONT_USE.include((Object)"getPeer");
        DONT_USE.include((Object)"create");
        DONT_USE.include((Object)"build");
        DONT_USE.include((Object)"toString");
        DONT_USE.include((Object)"paramString");
        DONT_USE.include((Object)"getNextEvent");
        DONT_USE.include((Object)"peekEvent");
    }
}

