/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import de.uni_hamburg.fs.ConceptImpl;
import de.uni_hamburg.fs.TypeException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Partition
implements Serializable {
    private Set<ConceptImpl> _concepts = new HashSet<ConceptImpl>();

    public Partition() {
    }

    public Partition(ConceptImpl con) {
        this._concepts.add(con);
        con._partitions.add(this);
    }

    public void union(Partition partition) throws TypeException {
        Iterator<ConceptImpl> conciterator = partition.concepts();
        while (conciterator.hasNext()) {
            ConceptImpl con = conciterator.next();
            this.addConcept(con);
        }
    }

    public void addConcept(ConceptImpl newcon) throws TypeException {
        for (ConceptImpl con : this._concepts) {
            if (con == newcon) {
                return;
            }
            if (!con.isa(newcon) && !newcon.isa(con)) continue;
            throw new TypeException();
        }
        for (ConceptImpl con : this._concepts) {
            con._partitions.remove(this);
        }
        this._concepts.add(newcon);
        for (ConceptImpl con : this._concepts) {
            con._partitions.add(this);
        }
    }

    public boolean containsConcept(ConceptImpl con) {
        return this._concepts.contains(con);
    }

    public Iterator<ConceptImpl> concepts() {
        return this._concepts.iterator();
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        Iterator<ConceptImpl> concs = this._concepts.iterator();
        int i = 1;
        while (concs.hasNext()) {
            if (i > 1) {
                output.append(',');
            }
            ConceptImpl con = concs.next();
            output.append(con.getName());
            ++i;
        }
        return output.toString();
    }

    public boolean equals(Object that) {
        if (that instanceof Partition) {
            return ((Partition)that)._concepts.equals(this._concepts);
        }
        return false;
    }

    public int hashCode() {
        return this._concepts.hashCode();
    }
}

