/*
 * Decompiled with CFR 0.152.
 */
package de.renew.layoutwindow;

import CH.ifa.draw.DrawPlugin;
import de.renew.draw.ui.api.MenuApi;
import de.renew.draw.ui.ontology.MenuSeparatorFactory;
import de.renew.layoutwindow.LayoutWindow;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.annotations.Inject;
import de.renew.plugin.di.DIPlugin;
import de.renew.windowmanagement.Workbench;
import javax.swing.JMenuItem;

public class LayoutWindowPlugin
extends DIPlugin {
    private static final String LAYOUT_WINDOW = "de.renew.layoutwindow.enable";
    private static final String LAYOUT_WINDOW_MENU_ITEM = "de.renew.layoutwindow.menuitem";
    private static final String LAYOUT_WINDOW_SEPARATOR = "de.renew.layoutwindow.separator";
    private final Workbench _workbench;

    @Inject
    public LayoutWindowPlugin(Workbench workbench) {
        this._workbench = workbench;
    }

    public void init() {
        if (PluginProperties.getUserProperties().getBoolProperty(LAYOUT_WINDOW, true)) {
            this.addLayoutWindowMenuEntry();
        }
    }

    public boolean cleanup() {
        DrawPlugin current = DrawPlugin.getCurrent();
        if (current == null) {
            return true;
        }
        MenuApi.unregisterMenu((String)LAYOUT_WINDOW_SEPARATOR);
        MenuApi.unregisterMenu((String)LAYOUT_WINDOW_MENU_ITEM);
        return true;
    }

    private void addLayoutWindowMenuEntry() {
        JMenuItem mi = new JMenuItem("Layout Window");
        mi.addActionListener(e -> LayoutWindow.openLayoutWindow(this._workbench));
        MenuSeparatorFactory factory = MenuApi.createMenuSeparatorFactory((String)"de.renew.extras");
        JMenuItem separator = factory.createSeparator();
        MenuApi.registerMenu((String)"Layout", (JMenuItem)separator, (String)LAYOUT_WINDOW_SEPARATOR);
        MenuApi.registerMenu((String)"Layout", (JMenuItem)mi, (String)LAYOUT_WINDOW_MENU_ITEM);
    }
}

