/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.analysis;

import de.renew.lola2.LolaPlugin;
import de.renew.lola2.analysis.DirectLolaResult;
import de.renew.lola2.analysis.LolaHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class LolaAnalyzer {
    private static Logger _logger = Logger.getLogger(LolaAnalyzer.class);
    public static final int TIMEOUT = 5;
    protected String _lolaPath;

    public LolaAnalyzer() {
        this._lolaPath = LolaPlugin.getLolaPath();
    }

    public LolaAnalyzer(String lolaPath) {
        this._lolaPath = lolaPath;
    }

    public DirectLolaResult callLola(String formula, File netFile) {
        return this.callLola(formula, netFile, new String[0]);
    }

    public DirectLolaResult callLola(String formula, File netFile, String[] parameter) {
        Runtime myrun = Runtime.getRuntime();
        File lolaBin = new File(this._lolaPath, "lola");
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("LolaAnalyzer.callLola: lolaBin, netFile, formula, parameter are " + String.valueOf(lolaBin) + " " + String.valueOf(netFile) + " " + formula + " " + String.valueOf(parameter)));
        }
        File jsonFile = null;
        try {
            jsonFile = File.createTempFile("lolaoutput", ".json", LolaHelper.findTmpDir());
        }
        catch (IOException ioe) {
            _logger.error((Object)"[Lola] Could not create temporary file for JSON output");
        }
        ArrayList<Object> argList = new ArrayList<Object>();
        argList.add(lolaBin.toString());
        argList.add(netFile.toString());
        argList.add("--timelimit=5");
        argList.add("--json=" + jsonFile.getAbsolutePath());
        if (formula != null) {
            argList.add("--formula=" + formula);
        }
        argList.addAll(Arrays.asList(parameter));
        String[] args = new String[argList.size()];
        args = argList.toArray(args);
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("[Lola] Executing " + this.renderCommand(args)));
        }
        StringBuilder outputBuilder = new StringBuilder();
        StringBuilder errorBuilder = new StringBuilder();
        int lolaRetVal = 1;
        try {
            Process lolproc = myrun.exec(args);
            lolaRetVal = lolproc.waitFor();
            BufferedReader outputReader = new BufferedReader(new FileReader(jsonFile));
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(lolproc.getErrorStream()));
            String line = "";
            while ((line = outputReader.readLine()) != null) {
                outputBuilder.append(line);
                outputBuilder.append(System.lineSeparator());
                _logger.debug((Object)("[callLola OUTPUT]" + line));
            }
            while ((line = errorReader.readLine()) != null) {
                errorBuilder.append(line);
                errorBuilder.append(System.lineSeparator());
                _logger.debug((Object)("[callLola ERROR]" + line));
            }
            _logger.debug((Object)("[Lola] Call returned exit value " + lolaRetVal));
            outputReader.close();
            errorReader.close();
        }
        catch (IOException e) {
            _logger.error((Object)"[Lola] Execution failed");
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            _logger.error((Object)"[Lola] Execution interrupted");
            e.printStackTrace();
        }
        DirectLolaResult lolaResult = new DirectLolaResult(lolaRetVal, outputBuilder.toString(), errorBuilder.toString());
        return lolaResult;
    }

    private String renderCommand(String[] args) {
        Object cmd = "";
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (((String)arg).contains(" ")) {
                arg = "\"" + (String)arg + "\"";
            }
            cmd = (String)cmd + (String)arg;
            if (i >= args.length - 1) continue;
            cmd = (String)cmd + " ";
        }
        return cmd;
    }
}

