/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.commands;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.util.Command;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.gui.CPNDrawing;
import de.renew.gui.GuiPlugin;
import de.renew.lola2.LolaFileCreator;
import de.renew.plugin.command.CLCommand;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class ExportToLolaCommand
extends Command
implements CLCommand {
    private static Logger _logger = Logger.getLogger(ExportToLolaCommand.class);

    public ExportToLolaCommand(String name) {
        super(name);
    }

    public void execute(String[] args, PrintStream response) {
    }

    public void execute() {
        DrawingEditor drawingEditor = GuiPlugin.getCurrent().getDrawingEditor();
        Drawing drawing = drawingEditor.drawing();
        JFrame editor = DrawPlugin.getGui().getFrame();
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        chooser.setDialogTitle("Select a file to save exported net.");
        chooser.setToolTipText("Good Luck.");
        int returnValue = chooser.showSaveDialog(editor);
        if (returnValue != 0) {
            _logger.info((Object)"User abort.");
            return;
        }
        File selectedFile = chooser.getSelectedFile();
        try {
            FileOutputStream stream = new FileOutputStream(selectedFile);
            LolaFileCreator creator = new LolaFileCreator();
            creator.writeLolaFile(stream, (CPNDrawing)drawing);
            stream.flush();
            ((OutputStream)stream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getDescription() {
        return "Export to lola format.";
    }
}

