/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.io;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.gui.CPNDrawing;
import de.renew.ioontology.FileFilter;
import de.renew.ioontology.importing.ImportFormatAbstract;
import de.renew.lola2.LolaFileFilter;
import de.renew.lola2.parser.LolaParser;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class LolaImportFormat
extends ImportFormatAbstract<Drawing> {
    public static final String FORMAT_NAME = "Lola net file";
    private static Logger _logger = Logger.getLogger(LolaImportFormat.class);

    public LolaImportFormat() {
        super(FORMAT_NAME, (FileFilter)new LolaFileFilter());
    }

    public List<Drawing> importFiles(URL[] paths) throws Exception {
        _logger.info((Object)"[Lola] Lola Import: Starting");
        ArrayList<Drawing> result = null;
        if (paths != null) {
            ArrayList<Drawing> drawings = new ArrayList<Drawing>();
            _logger.info((Object)("[Lola] Lola Import: Importing file " + paths[0].toString()));
            drawings.set(0, this.importFile(paths[0]));
            result = drawings;
        }
        assert (result != null) : "Failure in LolaImportFormat: result == null";
        return result;
    }

    public Drawing importFile(URL file) throws Exception {
        CPNDrawing result = null;
        if (file != null) {
            FileInputStream stream = new FileInputStream(new File(file.getFile()));
            result = new LolaParser().importNet(stream);
            stream.close();
        }
        assert (result != null) : "Failure in LolaImportFormat: result == null";
        return result;
    }
}

