/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.parser;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.framework.ParentFigure;
import de.renew.draw.storables.ontology.Figure;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNDrawingHelper;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.lola2.parser.Marking;
import de.renew.lola2.parser.NetFileParseError;
import de.renew.lola2.parser.Node;
import de.renew.lola2.parser.Place;
import de.renew.lola2.parser.Transition;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class LolaParser {
    private static Logger _logger = Logger.getLogger(LolaParser.class);
    private List<Transition> _transitions = new ArrayList<Transition>();
    private List<Place> _places = new ArrayList<Place>();
    private Map<String, Node> _elementsMap = new HashMap<String, Node>();
    private Map<Node, AttributeFigure> _figureMap = new HashMap<Node, AttributeFigure>();
    private final int _ordinaryArc = 1;

    public void parse(InputStream stream) throws NetFileParseError {
        _logger.info((Object)"[Lola] Lola Import: Starting parser.");
        Scanner scanner = new Scanner(new BufferedReader(new InputStreamReader(stream)));
        scanner.useDelimiter(";");
        try {
            scanner.findWithinHorizon("PLACE", 0);
            this._places = LolaParser.parsePlaces(scanner.next());
            for (Place place : this._places) {
                this._elementsMap.put(place.getName(), place);
            }
            scanner.findWithinHorizon("MARKING", 0);
            Map<Place, Integer> markings = this.parseMarking(scanner.next());
            for (Place p : markings.keySet()) {
                p.setInitialMarking(markings.get(p));
            }
            scanner.useDelimiter(";?\\s*TRANSITION");
            while (scanner.hasNext()) {
                Transition transition = this.parseTransition(scanner.next());
                this._transitions.add(transition);
                this._elementsMap.put(transition.getName(), transition);
            }
        }
        catch (NetFileParseError | NoSuchElementException e) {
            _logger.error((Object)"[Lola] An error occurred while trying to parse the net.");
        }
    }

    public Transition parseTransition(String transition) throws NetFileParseError {
        int[] coords;
        if (transition.trim().endsWith(";")) {
            transition = transition.substring(0, transition.trim().length());
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Now parsing the transition\n" + transition));
        }
        Scanner transitionScanner = new Scanner(transition);
        String nameLine = transitionScanner.next();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)nameLine);
        }
        String[] nameAndCoordinates = nameLine.split("\\{");
        String transitionName = nameAndCoordinates[0].trim();
        Transition result = new Transition(transitionName);
        if (nameLine.contains("{") && nameAndCoordinates.length > 1 && (coords = LolaParser.parseCoordinates(nameAndCoordinates[1].trim())) != null) {
            result.setX(coords[0]);
            result.setY(coords[1]);
        }
        if (transitionScanner.next().equals("CONSUME")) {
            transitionScanner.useDelimiter(";\\s*PRODUCE");
            String consumeBlock = transitionScanner.next();
            if (consumeBlock != null) {
                Map<Place, Integer> pre = this.parseMarking(consumeBlock);
                result.setPre(pre);
            }
        } else {
            throw new NetFileParseError("Missing CONSUME keyword");
        }
        if (!transitionScanner.hasNext()) {
            throw new NetFileParseError("Missing PRODUCE keyword");
        }
        Map<Place, Integer> post = this.parseMarking(transitionScanner.next());
        result.setPost(post);
        return result;
    }

    public Map<Place, Integer> parseMarking(String marking) throws NetFileParseError {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"Now parse the marking");
        }
        Scanner markingScanner = new Scanner(marking);
        markingScanner.useDelimiter(",");
        HashMap<Place, Integer> markings = new HashMap<Place, Integer>();
        while (markingScanner.hasNext()) {
            try {
                Marking found = LolaParser.parseToken(markingScanner.next());
                if (found == null) continue;
                Place place = (Place)this.forName(found.getName());
                markings.put(place, found.getTokens());
            }
            catch (NetFileParseError e) {
                e.printStackTrace();
                throw e;
            }
        }
        return markings;
    }

    public Node forName(String name) {
        return this._elementsMap.get(name);
    }

    public static Marking parseToken(String token) throws NetFileParseError {
        if (token != null && !token.trim().isEmpty()) {
            String[] placeTokens = token.split(":");
            if (placeTokens.length > 1) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)(placeTokens[0] + " has " + placeTokens[1] + " tokens."));
                }
                try {
                    Integer tokenCount = Integer.parseInt(placeTokens[1].trim());
                    Marking marking = new Marking(placeTokens[0].trim(), tokenCount);
                    return marking;
                }
                catch (NumberFormatException e) {
                    throw new NetFileParseError("Could not parse token number");
                }
            }
            throw new NetFileParseError("Place without marking not allowed in MARKING section");
        }
        return null;
    }

    public static List<Place> parsePlaces(String places) throws NetFileParseError {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"First parse the places");
        }
        Scanner placeScanner = new Scanner(places);
        placeScanner.useDelimiter(",");
        ArrayList<Place> result = new ArrayList<Place>();
        while (placeScanner.hasNext()) {
            result.add(LolaParser.parsePlace(placeScanner.next()));
        }
        return result;
    }

    public static Place parsePlace(String place) throws NetFileParseError {
        int[] coords;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)place);
        }
        Scanner placeScanner = new Scanner(place);
        placeScanner.useDelimiter("\\{");
        String placeName = placeScanner.next().trim();
        Place result = new Place(placeName);
        if (placeScanner.hasNext() && (coords = LolaParser.parseCoordinates(placeScanner.next())) != null) {
            result.setX(coords[0]);
            result.setY(coords[1]);
        }
        return result;
    }

    private static int[] parseCoordinates(String coordinates) throws NetFileParseError {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)coordinates);
        }
        if (coordinates.startsWith("x") && coordinates.contains("y")) {
            int[] coordArray = new int[2];
            try {
                String xs = coordinates.substring(coordinates.indexOf(":") + 1, coordinates.indexOf("y"));
                String ys = coordinates.substring(coordinates.lastIndexOf(":") + 1, coordinates.indexOf("}"));
                coordArray[0] = Integer.parseInt(xs);
                coordArray[1] = Integer.parseInt(ys);
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Coordinates: (x=" + xs + "|y=" + ys + ")"));
                }
            }
            catch (NumberFormatException e) {
                throw new NetFileParseError("Coordinates could not be parsed");
            }
            return coordArray;
        }
        throw new NetFileParseError("Comment does not contain coordinates");
    }

    public CPNDrawing importNet(InputStream stream) {
        try {
            this.parse(stream);
        }
        catch (NetFileParseError e) {
            _logger.error((Object)("[LolaParser] : " + e.getMessage()));
            return new CPNDrawing();
        }
        CPNDrawing drawing = new CPNDrawing();
        CPNDrawingHelper drawer = new CPNDrawingHelper();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"Drawing places");
        }
        for (Place p : this._places) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Drawing place " + String.valueOf(p) + " (" + p.getX() + "|" + p.getY()));
            }
            PlaceFigure place = drawer.createPlace();
            if (p.hasCoordinates()) {
                place.moveBy(p.getX().intValue(), p.getY().intValue());
            }
            drawing.add((Figure)place);
            drawing.add((Figure)drawer.createNameTextFigure(p.getName(), (ParentFigure)place));
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Added and named place " + String.valueOf(p)));
            }
            this._figureMap.put(p, (AttributeFigure)place);
            if (!p.initiallyMarked()) continue;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Adding marking " + p.getInitialMarking()));
            }
            for (int j = 0; j < p.getInitialMarking(); ++j) {
                drawing.add((Figure)drawer.createInscription("[]", (ParentFigure)place));
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"Drawing transitions");
        }
        for (Transition t : this._transitions) {
            ArcConnection arc;
            TransitionFigure transition = drawer.createTransition();
            if (t.hasCoordinates()) {
                transition.moveBy(t.getX().intValue(), t.getY().intValue());
            }
            drawing.add((Figure)transition);
            this._figureMap.put(t, (AttributeFigure)transition);
            drawing.add((Figure)drawer.createNameTextFigure(t.getName(), (ParentFigure)transition));
            for (Place p : t.getPre().keySet()) {
                arc = drawer.createArcConnection(this.figureOf(p), (AttributeFigure)transition, 1);
                drawing.add((Figure)arc);
                int tokenpre = t.getPre().get(p);
                if (tokenpre <= 1) continue;
                drawing.add((Figure)drawer.createWeightTextFigure(arc, tokenpre));
            }
            for (Place p : t.getPost().keySet()) {
                arc = drawer.createArcConnection((AttributeFigure)transition, this.figureOf(p), 1);
                drawing.add((Figure)arc);
                int tokenpost = t.getPost().get(p);
                if (tokenpost <= 1) continue;
                drawing.add((Figure)drawer.createWeightTextFigure(arc, tokenpost));
            }
        }
        return drawing;
    }

    private AttributeFigure figureOf(Node p) {
        return this._figureMap.get(p);
    }

    public List<Transition> getTransitions() {
        return this._transitions;
    }

    public List<Place> getPlaces() {
        return this._places;
    }
}

