/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.edit;

import de.renew.refactoring.edit.FileMatchSorter;
import de.renew.refactoring.edit.IteratorEditor;
import de.renew.refactoring.match.FileMatch;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class FileEditor
extends IteratorEditor<FileMatch, Void> {
    private static final Logger LOGGER = Logger.getLogger(FileEditor.class);

    public FileEditor(List<FileMatch> edits) {
        super(new FileMatchSorter().sorted(edits));
    }

    @Override
    public String getCurrentEditString() {
        return ((FileMatch)this.getCurrentEdit()).getFile().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void performEdit(FileMatch edit) {
        BufferedReader in = null;
        BufferedWriter out = null;
        File file = edit.getFile();
        try {
            File tmpFile = new File(file.getPath() + "tmp");
            tmpFile.createNewFile();
            in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tmpFile)));
            String oldLine = in.readLine();
            int lineNumber = 1;
            while (oldLine != null) {
                String newLine = lineNumber == edit.getLine() ? this.editLine(oldLine, edit) : oldLine;
                out.write(newLine);
                out.newLine();
                oldLine = in.readLine();
                ++lineNumber;
            }
            if (file.delete() && tmpFile.renameTo(file)) {
                LOGGER.info((Object)("Replacing file successful: " + String.valueOf(file)));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("I/O Error occured while trying to replace " + String.valueOf(file) + "."));
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected abstract String editLine(String var1, FileMatch var2);
}

