/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.inline;

import CH.ifa.draw.util.FloatingTextField;
import de.renew.refactoring.inline.RestrictedEditingFilters;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.border.LineBorder;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import org.apache.log4j.Logger;

public class FloatingRestrictedEditingTextField
extends FloatingTextField {
    private static final Logger LOGGER = Logger.getLogger(FloatingRestrictedEditingTextField.class);
    private final RestrictedEditingFilters _restrict;

    public FloatingRestrictedEditingTextField(int startIndex, int endIndex) {
        this._restrict = new RestrictedEditingFilters(this.fEditWidget, startIndex, endIndex);
    }

    public void createOverlay(Container container, Rectangle minimum, Font font) {
        ((AbstractDocument)this.fEditWidget.getDocument()).setDocumentFilter(this._restrict.getDocumentFilter());
        this.fEditWidget.setNavigationFilter(this._restrict.getNavigationFilter());
        super.createOverlay(container, minimum, font);
    }

    public Document getDocument() {
        return this.fEditWidget.getDocument();
    }

    public int getStartIndex() {
        return this._restrict.getStartIndex();
    }

    public int getEndIndex() {
        return this._restrict.getEndIndex();
    }

    public void setBorderColor(Color color) {
        this.scrollPane.setBorder(new LineBorder(color));
    }

    public String getEditedText() {
        String newText = this.fEditWidget.getText();
        try {
            return newText.substring(this.getStartIndex(), this.getEndIndex());
        }
        catch (StringIndexOutOfBoundsException e) {
            return "";
        }
    }

    public void setCaretPosition(int index) {
        this.fEditWidget.select(index, index);
        this.fEditWidget.setCaretPosition(index);
    }

    public int getCaretPosition() {
        return this.fEditWidget.getCaretPosition();
    }

    public void select(int startIndex, int endIndex) {
        this.fEditWidget.select(startIndex, endIndex);
    }
}

