/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.inline;

import CH.ifa.draw.standard.TextHolder;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.gui.CPNTextFigure;
import de.renew.refactoring.inline.FloatingRestrictedEditingTextField;
import de.renew.refactoring.inline.InlineStepWithListener;
import de.renew.refactoring.match.StringMatch;
import java.awt.Color;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class RestrictedEditingTextFieldStep
extends InlineStepWithListener {
    private static final Logger LOGGER = Logger.getLogger(RestrictedEditingTextFieldStep.class);
    private CPNTextFigure _textFigure;
    private Container _container;
    private FloatingRestrictedEditingTextField _textField;
    private String _originalText;
    private String _lastKnownText;
    private String _lastKnownEditedText;
    private int _editCounter;
    protected MouseListener _mouseListener;

    public RestrictedEditingTextFieldStep(Container container, CPNTextFigure textFigure, StringMatch stringMatch) {
        this._container = container;
        this._textFigure = textFigure;
        this._originalText = textFigure.getText();
        this.beginEdit(stringMatch);
    }

    public void editedTextChanged(String text) {
    }

    public String getEditedText() {
        return this._textField.getEditedText();
    }

    public String getText() {
        return this._textField.getText();
    }

    protected KeyListener textFieldKeyListener() {
        return null;
    }

    protected MouseListener containerMouseListener() {
        if (this._mouseListener == null) {
            this._mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    RestrictedEditingTextFieldStep.this.endEdit();
                }
            };
        }
        return this._mouseListener;
    }

    public void setBorderColor(Color borderColor) {
        this._textField.setBorderColor(borderColor);
    }

    private void beginEdit(StringMatch stringMatch) {
        this._textField = new FloatingRestrictedEditingTextField(stringMatch.start(), stringMatch.end());
        this._textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                RestrictedEditingTextFieldStep.this.edited();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                RestrictedEditingTextFieldStep.this.edited();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RestrictedEditingTextFieldStep.this.edited();
            }
        });
        this._textField.addKeyListener(this.textFieldKeyListener());
        this._container.addMouseListener(this.containerMouseListener());
        this.setText(this._textFigure.getText());
        this._textField.select(stringMatch.start(), stringMatch.end());
        this._textField.createOverlay(this._container, RestrictedEditingTextFieldStep.fieldBounds((TextHolder)this._textFigure), this._textFigure.getFont());
    }

    private void edited() {
        String newEditedText;
        if (this.getText().isEmpty() && !this._lastKnownText.equals(this._lastKnownEditedText)) {
            return;
        }
        this._lastKnownText = this.getText();
        String string = newEditedText = this._lastKnownText.isEmpty() ? "" : this.getEditedText();
        if (newEditedText.equals(this._lastKnownEditedText)) {
            return;
        }
        this._lastKnownEditedText = newEditedText;
        this.editedTextChanged(newEditedText);
        this.updateTextFieldFromTextFigure();
        this._textFigure.setText(this._originalText);
        this._textFigure.changed();
    }

    private void updateTextFieldFromTextFigure() {
        final int thisEdit = ++this._editCounter;
        final String oldText = this._lastKnownText;
        final String newText = this._textFigure.getText();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (thisEdit == RestrictedEditingTextFieldStep.this._editCounter && !newText.equals(oldText)) {
                    int caret = RestrictedEditingTextFieldStep.this._textField.getCaretPosition();
                    RestrictedEditingTextFieldStep.this.setText(newText);
                    RestrictedEditingTextFieldStep.this._textField.setCaretPosition(caret);
                }
            }
        });
    }

    private void setText(String text) {
        this._textField.setText(text);
        this._lastKnownText = text;
    }

    public void endEdit() {
        String newText = this.getText();
        this._textFigure.setText(newText);
        if (newText.trim().length() == 0) {
            RestrictedEditingTextFieldStep.getEditor().drawing().remove((Figure)this._textFigure);
        }
        this._textField.endOverlay();
        RestrictedEditingTextFieldStep.getEditor().view().checkDamage();
        RestrictedEditingTextFieldStep.getEditor().toolDone();
        this._container.removeMouseListener(this.containerMouseListener());
        this.informListenersFinished();
    }

    private static Rectangle fieldBounds(TextHolder figure) {
        Rectangle box = figure.textDisplayBox();
        return box;
    }

    private static DrawingEditor getEditor() {
        return EditorApi.getCurrentEditor();
    }
}

