/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.renamechannel;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.refactoring.parse.JNPLinkParser;
import de.renew.refactoring.renamechannel.NoLinkSelectedException;
import de.renew.refactoring.renamechannel.RenameChannelSelectedLinkFinder;
import de.renew.refactoring.renamechannel.RenameChannelWizardController;
import de.renew.refactoring.wizard.SingleWizardCommand;
import de.renew.refactoring.wizard.Wizard;
import java.util.Vector;

public class RenameChannelCommand
extends SingleWizardCommand {
    private static final String COMMAND_NAME = "Rename channel...";

    public RenameChannelCommand() {
        super(COMMAND_NAME);
    }

    public void execute() {
        Drawing drawing = RenameChannelCommand.getEditor().drawing();
        Vector selection = RenameChannelCommand.getEditor().view().selection();
        try {
            RenameChannelWizardController controller = new RenameChannelWizardController(new JNPLinkParser(), drawing, selection);
            this.setWizard(new Wizard(controller));
        }
        catch (NoLinkSelectedException e) {
            RenameChannelCommand.getEditor().showStatus("There is a syntax error or no uplink or downlink selected.");
        }
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        Vector selection = RenameChannelCommand.getEditor().view().selection();
        Drawing drawing = RenameChannelCommand.getEditor().drawing();
        return new RenameChannelSelectedLinkFinder(null, drawing, selection).isTextFigureOrTransitionFigureSelected();
    }

    private static DrawingEditor getEditor() {
        return EditorApi.getCurrentEditor();
    }
}

