/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.renamechannel;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.TransitionFigure;
import de.renew.refactoring.match.DownlinkMatch;
import de.renew.refactoring.match.LinkMatch;
import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.match.UplinkMatch;
import de.renew.refactoring.parse.LinkParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

class RenameChannelSelectedLinkFinder {
    private static final Logger LOGGER = Logger.getLogger(RenameChannelSelectedLinkFinder.class);
    private final LinkParser _parser;
    private final Drawing _drawing;
    private final Figure _selectedFigure;

    RenameChannelSelectedLinkFinder(LinkParser parser, Drawing drawing, List<Figure> selection) {
        this._parser = parser;
        this._drawing = drawing;
        this._selectedFigure = selection.size() == 1 ? selection.get(0) : null;
    }

    boolean isTextFigureOrTransitionFigureSelected() {
        return this._selectedFigure instanceof CPNTextFigure || this._selectedFigure instanceof TransitionFigure;
    }

    boolean isLinkSelected() {
        return this.findSelectedLinks().size() > 0;
    }

    List<LinkMatch> findSelectedLinks() {
        CPNTextFigure textFigure;
        if (this._selectedFigure instanceof TransitionFigure) {
            return this.findLinks((TransitionFigure)this._selectedFigure);
        }
        if (this._selectedFigure instanceof CPNTextFigure && RenameChannelSelectedLinkFinder.hasParentTransitionFigure(textFigure = (CPNTextFigure)this._selectedFigure)) {
            return this.findLinks(textFigure);
        }
        return Collections.emptyList();
    }

    private List<LinkMatch> findLinks(CPNTextFigure textFigure) {
        ArrayList<LinkMatch> links = new ArrayList<LinkMatch>();
        String text = textFigure.getText();
        StringMatch uplinkMatch = this._parser.findUplink(text);
        if (uplinkMatch != null) {
            StringMatch channelNameMatch = this._parser.findChannelName(uplinkMatch.match());
            int parameterCount = this._parser.findParameterCount(uplinkMatch.match());
            links.add(new UplinkMatch(this._drawing, textFigure, uplinkMatch, channelNameMatch, parameterCount));
        }
        for (StringMatch downlinkMatch : this._parser.findDownlinks(text)) {
            StringMatch channelNameMatch = this._parser.findChannelName(downlinkMatch.match());
            int parameterCount = this._parser.findParameterCount(downlinkMatch.match());
            links.add(new DownlinkMatch(this._drawing, textFigure, downlinkMatch, channelNameMatch, parameterCount));
        }
        return links;
    }

    private List<LinkMatch> findLinks(TransitionFigure transitionFigure) {
        ArrayList<LinkMatch> links = new ArrayList<LinkMatch>();
        FigureEnumeration children = transitionFigure.children();
        while (children.hasMoreElements()) {
            Figure child = (Figure)children.nextElement();
            if (!(child instanceof CPNTextFigure)) continue;
            links.addAll(this.findLinks((CPNTextFigure)child));
        }
        return links;
    }

    private static boolean hasParentTransitionFigure(CPNTextFigure textFigure) {
        return textFigure.parent() instanceof TransitionFigure;
    }
}

