/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.renamevariable;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNDrawingView;
import de.renew.refactoring.inline.SingleInlineUndoableCommand;
import de.renew.refactoring.parse.DeclarationFinder;
import de.renew.refactoring.parse.JNPVariableParser;
import de.renew.refactoring.renamevariable.NoVariableSelectedException;
import de.renew.refactoring.renamevariable.RenameVariableInlineController;
import de.renew.refactoring.renamevariable.RenameVariableSelectionChecker;
import java.util.Vector;
import org.apache.log4j.Logger;

public class RenameVariableCommand
extends SingleInlineUndoableCommand {
    private static final Logger LOGGER = Logger.getLogger(RenameVariableCommand.class);
    private static final String COMMAND_NAME = "Rename variable...";

    public RenameVariableCommand() {
        super(COMMAND_NAME);
    }

    protected boolean executeUndoable() {
        Drawing drawing = this.getEditor().drawing();
        String declaration = new DeclarationFinder(drawing).declarationText();
        CPNDrawingView drawingView = (CPNDrawingView)this.getEditor().view();
        try {
            RenameVariableInlineController controller = new RenameVariableInlineController(new JNPVariableParser(declaration), drawingView);
            this.setInline(controller);
        }
        catch (NoVariableSelectedException e) {
            this.getEditor().showStatus("There is a syntax error or no variable is selected.");
            return false;
        }
        return true;
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        Drawing drawing = this.getEditor().drawing();
        if (!(drawing instanceof CPNDrawing)) {
            return false;
        }
        Vector selection = this.getEditor().view().selection();
        RenameVariableSelectionChecker selChecker = new RenameVariableSelectionChecker(selection, null);
        if (selChecker.isTextFigureSelected()) {
            return true;
        }
        DeclarationFinder declFinder = new DeclarationFinder(drawing);
        return declFinder.hasDeclarationFigure();
    }
}

