/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.util;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DrawingHelper {
    private DrawingHelper() {
    }

    public static List<Object> mergeDrawingLists(List<Drawing> drawings, List<File> files) {
        ArrayList<Drawing> result = new ArrayList<Drawing>(drawings);
        for (File file : files) {
            String filename = StringUtil.getFilename((String)file.getPath());
            if (DrawingHelper.containsDrawingWithFileName(drawings, filename)) continue;
            result.add((Drawing)file);
        }
        return result;
    }

    public static boolean containsDrawingWithFileName(List<Drawing> drawings, String filename) {
        for (Drawing drawing : drawings) {
            if (!drawing.getName().equals(filename)) continue;
            return true;
        }
        return false;
    }

    public static List<Drawing> toDrawingList(Iterator<Drawing> iterator) {
        ArrayList<Drawing> list = new ArrayList<Drawing>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }
}

