/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ButtonContentFilter;
import bibliothek.gui.dock.action.ButtonContentFilterListener;
import bibliothek.gui.dock.action.DockAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractButtonContentFilter
implements ButtonContentFilter {
    private List<ButtonContentFilterListener> listeners = new ArrayList<ButtonContentFilterListener>();
    private Map<DockAction, Map<Dockable, Integer>> count = new HashMap<DockAction, Map<Dockable, Integer>>();

    public void addListener(ButtonContentFilterListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ButtonContentFilterListener listener) {
        this.listeners.remove(listener);
    }

    protected void fire(Dockable dockable, DockAction action) {
        for (ButtonContentFilterListener listener : this.listeners.toArray(new ButtonContentFilterListener[this.listeners.size()])) {
            listener.showTextChanged(this, dockable, action);
        }
    }

    protected void installed(DockAction action, Dockable dockable) {
    }

    protected void installed(DockAction action) {
    }

    protected void uninstalled(DockAction action, Dockable dockable) {
    }

    protected void uninstalled(DockAction action) {
    }

    public void install(Dockable dockable, DockAction action) {
        Integer count;
        Map<Dockable, Integer> actionCount = this.count.get(action);
        if (actionCount == null) {
            actionCount = new HashMap<Dockable, Integer>();
            this.count.put(action, actionCount);
            this.installed(action);
        }
        if ((count = actionCount.get(dockable)) == null) {
            count = 1;
            this.installed(action, dockable);
        } else {
            count = count + 1;
        }
        actionCount.put(dockable, count);
    }

    public void uninstall(Dockable dockable, DockAction action) {
        Map<Dockable, Integer> actionCount = this.count.get(action);
        Integer count = actionCount.get(dockable);
        if (count == 1) {
            actionCount.remove(dockable);
            this.uninstalled(action, dockable);
        } else {
            actionCount.put(dockable, count - 1);
        }
        if (actionCount.isEmpty()) {
            this.count.remove(action);
            this.uninstalled(action);
        }
    }
}

