/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.util.Workarounds;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class OverpaintablePanel
extends JLayeredPane {
    private Overlay overlay = new Overlay();
    private JComponent content = new JPanel();
    private JComponent base = this.content;
    private boolean solid = true;

    public OverpaintablePanel() {
        this.content.setOpaque(false);
        this.setLayer(this.base, DEFAULT_LAYER);
        this.setLayer(this.overlay, DRAG_LAYER);
        this.add(this.base);
        this.add(this.overlay);
    }

    public void setSolid(boolean solid) {
        this.solid = solid;
        this.setOpaque(solid);
        if (this.base != this.content) {
            this.base.setOpaque(solid);
        }
    }

    public boolean isSolid() {
        return this.solid;
    }

    public void setContentPane(JComponent content) {
        if (content == null) {
            throw new IllegalArgumentException("Content must not be null");
        }
        this.content = content;
        this.setSolid(this.isSolid());
    }

    public JComponent getContentPane() {
        return this.content;
    }

    public void setBasePane(JComponent base) {
        if (base == null) {
            throw new IllegalArgumentException("Base must not be null");
        }
        this.content = base;
        this.remove(this.base);
        this.base = base;
        this.setLayer(base, DEFAULT_LAYER);
        this.add(base);
        this.setSolid(this.isSolid());
    }

    public JComponent getBasePane() {
        return this.base;
    }

    protected void paintOverlay(Graphics g) {
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        Dimension sizeBase = null;
        if (this.base != null) {
            sizeBase = this.base.getMinimumSize();
        }
        Dimension sizeOverlay = null;
        if (this.overlay != null) {
            sizeOverlay = this.overlay.getMinimumSize();
        }
        if (sizeBase == null && sizeOverlay == null) {
            return super.getMinimumSize();
        }
        return this.max(sizeBase, sizeOverlay);
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension sizeBase = null;
        if (this.base != null) {
            sizeBase = this.base.getPreferredSize();
        }
        Dimension sizeOverlay = null;
        if (this.overlay != null) {
            sizeOverlay = this.overlay.getPreferredSize();
        }
        if (sizeBase == null && sizeOverlay == null) {
            return super.getPreferredSize();
        }
        return this.max(sizeBase, sizeOverlay);
    }

    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        Dimension sizeBase = null;
        if (this.base != null) {
            sizeBase = this.base.getMaximumSize();
        }
        Dimension sizeOverlay = null;
        if (this.overlay != null) {
            sizeOverlay = this.overlay.getMaximumSize();
        }
        if (sizeBase == null && sizeOverlay == null) {
            return super.getMaximumSize();
        }
        return this.min(sizeBase, sizeOverlay);
    }

    private Dimension min(Dimension a, Dimension b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new Dimension(Math.min(a.width, b.width), Math.min(a.height, b.height));
    }

    private Dimension max(Dimension a, Dimension b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new Dimension(Math.max(a.width, b.width), Math.max(a.height, b.height));
    }

    public void doLayout() {
        Insets insets = this.getInsets();
        int x = 0;
        int y = 0;
        int width = this.getWidth();
        int height = this.getHeight();
        if (insets != null) {
            x = insets.left;
            y = insets.top;
            width -= insets.left + insets.right;
            height -= insets.top + insets.bottom;
        }
        this.base.setBounds(x, y, width, height);
        this.overlay.setBounds(x, y, width, height);
    }

    private class Overlay
    extends JPanel {
        public Overlay() {
            this.setLayout(null);
            this.setOpaque(false);
            Workarounds.getDefault().markAsGlassPane(this);
        }

        public boolean contains(int x, int y) {
            return false;
        }

        protected void paintComponent(Graphics g) {
            OverpaintablePanel.this.paintOverlay(g);
        }

        public Dimension getMinimumSize() {
            return new Dimension(0, 0);
        }

        public Dimension getPreferredSize() {
            return new Dimension(0, 0);
        }
    }
}

