/*
 * Decompiled with CFR 0.152.
 */
package de.renew.application;

import de.renew.simulator.api.ISimulatorExtensions;
import de.renew.simulatorontology.simulation.SimulatorExtension;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;

class SimulatorExtensionsImpl
implements ISimulatorExtensions {
    private static final Logger LOGGER = Logger.getLogger(SimulatorExtensionsImpl.class);
    private final Queue<SimulatorExtension> _extensions = new ConcurrentLinkedQueue<SimulatorExtension>();

    SimulatorExtensionsImpl() {
    }

    public void addExtension(SimulatorExtension extension) {
        LOGGER.debug((Object)("SimulatorExtensions: Registering extension " + String.valueOf(extension) + "."));
        this._extensions.add(extension);
    }

    public void removeExtension(SimulatorExtension extension) {
        LOGGER.debug((Object)("SimulatorExtensions: Deregistering extension " + String.valueOf(extension) + "."));
        this._extensions.remove(extension);
    }

    public Collection<SimulatorExtension> getSimulationExtensions() {
        return Collections.unmodifiableCollection(this._extensions);
    }

    public void cleanup() {
        this._extensions.clear();
    }
}

