/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database;

import de.renew.database.DatabaseRestoreSource;
import de.renew.database.DatabaseTransactionStrategy;
import de.renew.database.NetInstanceMap;
import de.renew.database.RestoreSource;
import de.renew.database.TransactionSource;
import de.renew.database.entitylayer.Entity;
import de.renew.database.entitylayer.NetInstanceEntity;
import de.renew.database.entitylayer.SQLDialect;
import de.renew.database.entitylayer.TokenEntity;
import de.renew.database.entitylayer.TokenPositionEntity;
import de.renew.net.IDRegistry;
import de.renew.net.IDSource;
import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.net.NetInstanceImpl;
import de.renew.net.NetLookup;
import de.renew.net.Place;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TrivialIDFactory;
import de.renew.plugin.PluginManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SetupHelper {
    private static final Logger LOGGER = Logger.getLogger(SetupHelper.class);

    private SetupHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetInstanceMap restoreNetInstances(RestoreSource source) throws Exception {
        Object token;
        SimulatablePlaceInstance pi;
        NetInstance instance;
        String[] netIDs = source.getAllNetIDs();
        int n = netIDs.length;
        Net[] nets = new Net[n];
        NetInstance[] instances = new NetInstance[n];
        NetInstanceMap map = new NetInstanceMap();
        NetLookup netLookup = new NetLookup();
        for (int i = 0; i < n; ++i) {
            Net net;
            String id = netIDs[i];
            nets[i] = net = netLookup.findForName(source.getNetName(id));
            assert (net != null);
            instance = net.getInstantiator().buildInstance();
            instance.setID(id);
            instances[i] = instance;
            map.put(id, instance);
            for (Place place : net.places()) {
                pi = (SimulatablePlaceInstance)instance.getInstance(place);
                pi._lock.lock();
                try {
                    pi.extractAllTokens(new Vector<Object>(), new Vector<Double>());
                }
                finally {
                    pi._lock.unlock();
                }
            }
        }
        Hashtable<String, Object> idToToken = source.getTokens(map);
        Enumeration<String> enumeration = idToToken.keys();
        while (enumeration.hasMoreElements()) {
            String id = enumeration.nextElement();
            token = idToToken.get(id);
            IDRegistry.getInstance().setAndReserveID(token, id);
        }
        for (int i = 0; i < n; ++i) {
            instance = instances[i];
            for (Place place : nets[i].places()) {
                pi = (SimulatablePlaceInstance)instance.getInstance(place);
                pi._lock.lock();
                try {
                    Vector<String> ids = new Vector<String>();
                    source.fillInAllTokens(pi, ids);
                    int num = ids.size();
                    for (int j = 0; j < num; ++j) {
                        String id = ids.elementAt(j);
                        Object token2 = idToToken.get(id);
                        pi.insertTokenWithID(token2, id, 0.0);
                    }
                }
                finally {
                    pi._lock.unlock();
                }
            }
        }
        enumeration = idToToken.keys();
        while (enumeration.hasMoreElements()) {
            String id = enumeration.nextElement();
            token = idToToken.get(id);
            IDRegistry.getInstance().unreserve(token);
        }
        return map;
    }

    public static SimulationState setup(Properties properties) {
        DatabaseRestoreSource restoreSource;
        SQLDialect dialect;
        String dbDriver = properties.getProperty("de.renew.simdb.driver");
        String dbDialect = properties.getProperty("de.renew.simdb.dialect");
        String dbUrl = properties.getProperty("de.renew.simdb.url");
        String dbUser = properties.getProperty("de.renew.simdb.user");
        String dbPassword = properties.getProperty("de.renew.simdb.password");
        if (dbUrl == null && dbDriver == null) {
            return SimulationState.TERMINATED_STATE;
        }
        if (dbUrl == null || dbDriver == null) {
            LOGGER.error((Object)(SetupHelper.class.getSimpleName() + ": Error: Specify de.renew.simdb.url and de.renew.simdb.driver system properties together to use a simulation database."));
            return SimulationState.TERMINATED_STATE;
        }
        if (dbPassword == null) {
            dbPassword = "";
        }
        if (dbDialect == null) {
            dbDialect = "de.renew.database.entitylayer.SQLDialect";
            LOGGER.warn((Object)(SetupHelper.class.getSimpleName() + ": The system property de.renew.simdb.dialect has not been specified. Using default dialect " + dbDialect));
        }
        ClassLoader classLoader = PluginManager.getInstance().getBottomClassLoader();
        try {
            Class<?> driverClass = Class.forName(dbDriver, true, classLoader);
            Constructor<?> constructor = driverClass.getConstructor(new Class[0]);
            constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)(SetupHelper.class.getSimpleName() + ": Cannot set simulation database.\nDatabase driver class " + dbDriver + " not found."));
            return SimulationState.TERMINATED_STATE;
        }
        catch (IllegalAccessException | SecurityException e) {
            LOGGER.error((Object)(SetupHelper.class.getSimpleName() + ": Cannot set simulation database.\nDatabase driver class's default constructor is not accessible."));
            return SimulationState.TERMINATED_STATE;
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)(SetupHelper.class.getSimpleName() + ": Cannot set simulation database.\nDatabase driver class's default constructor cannot be invoked."));
            return SimulationState.TERMINATED_STATE;
        }
        catch (InstantiationException e) {
            LOGGER.error((Object)(SetupHelper.class.getSimpleName() + ": Cannot set simulation database.\nDatabase driver class is abstract or an interface."));
            return SimulationState.TERMINATED_STATE;
        }
        catch (InvocationTargetException e) {
            LOGGER.error((Object)(SetupHelper.class.getSimpleName() + ": Cannot set simulation database.\nDatabase driver class's default constructor threw an exception:\n" + String.valueOf(e.getTargetException())));
            return SimulationState.TERMINATED_STATE;
        }
        catch (NoSuchMethodException e) {
            LOGGER.error((Object)(SetupHelper.class.getSimpleName() + ": Cannot set simulation database.\nDatabase driver class has no default constructor."));
            return SimulationState.TERMINATED_STATE;
        }
        try {
            Class<?> dialectClass = Class.forName(dbDialect, true, classLoader);
            Constructor<?> constructor = dialectClass.getConstructor(new Class[0]);
            dialect = (SQLDialect)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)(SetupHelper.class.getSimpleName() + ": Cannot set simulation database.\nSQL dialect class " + dbDialect + " not found."));
            return SimulationState.TERMINATED_STATE;
        }
        catch (IllegalAccessException | SecurityException e) {
            LOGGER.error((Object)(SetupHelper.class.getSimpleName() + ": Cannot set simulation database.\nSQL dialect class's default constructor is not accessible."));
            return SimulationState.TERMINATED_STATE;
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)(SetupHelper.class.getSimpleName() + ": Cannot set simulation database.\nSQL dialect class's default constructor cannot be invoked."));
            return SimulationState.TERMINATED_STATE;
        }
        catch (InstantiationException e) {
            LOGGER.error((Object)(SetupHelper.class.getSimpleName() + ": Cannot set simulation database.\nSQL dialect is an abstract class or an interface."));
            return SimulationState.TERMINATED_STATE;
        }
        catch (InvocationTargetException e) {
            LOGGER.error((Object)(SetupHelper.class.getSimpleName() + ": Cannot set simulation database.\nSQL dialect class's default constructor threw an exception:\n" + String.valueOf(e.getTargetException())));
            return SimulationState.TERMINATED_STATE;
        }
        catch (NoSuchMethodException e) {
            LOGGER.error((Object)(SetupHelper.class.getSimpleName() + ": Cannot set simulation database.\nSQL dialect class has no default constructor."));
            return SimulationState.TERMINATED_STATE;
        }
        ArrayList<NetInstance> netInstances = new ArrayList<NetInstance>();
        try {
            Connection connection;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)(SetupHelper.class.getSimpleName() + ": Connecting to simulation database " + dbUrl + "..."));
            }
            if (dbUser != null) {
                connection = DriverManager.getConnection(dbUrl, dbUser, dbPassword);
                connection.setAutoCommit(false);
            } else {
                connection = DriverManager.getConnection(dbUrl);
                connection.setAutoCommit(false);
            }
            restoreSource = new DatabaseRestoreSource(connection, dialect);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)(SetupHelper.class.getSimpleName() + ": Connected."));
            }
            NetInstanceImpl._useGlobalIDRegistry = true;
            if (restoreSource.wasSimulationInited()) {
                String[] viewedNetInstanceIds;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)(SetupHelper.class.getSimpleName() + ": Loading simulation state..."));
                }
                NetInstanceMap map = SetupHelper.restoreNetInstances(restoreSource);
                IDSource.setFactory(new TrivialIDFactory(restoreSource.getLastId() + 1));
                for (String viewedNetInstanceId : viewedNetInstanceIds = restoreSource.getViewedNetIDs()) {
                    netInstances.add(map.get(viewedNetInstanceId));
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)(SetupHelper.class.getSimpleName() + ": Simulation state loaded."));
                }
            } else {
                SetupHelper.clearDatabase(connection, dialect);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(SetupHelper.class.getSimpleName() + ": Cleared database."));
                }
            }
            connection.commit();
        }
        catch (Exception e) {
            LOGGER.error((Object)(SetupHelper.class.getSimpleName() + ": Cannot load simulation state.\nThere was an exception:"));
            LOGGER.error((Object)(SetupHelper.class.getSimpleName() + ": " + e.getMessage()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(SetupHelper.class.getSimpleName() + ": " + String.valueOf(e)));
            }
            LOGGER.error((Object)(SetupHelper.class.getSimpleName() + ": Simulation database abandoned."));
            return SimulationState.TERMINATED_STATE;
        }
        try {
            if (dbUser != null) {
                TransactionSource.setStrategy(new DatabaseTransactionStrategy(dbUrl, dbUser, dbPassword, dialect));
            } else {
                TransactionSource.setStrategy(new DatabaseTransactionStrategy(dbUrl, dialect));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(SetupHelper.class.getSimpleName() + ": Cannot assign simulation database.\nThere was an exception:"));
            LOGGER.error((Object)(SetupHelper.class.getSimpleName() + ": " + e.getMessage()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(SetupHelper.class.getSimpleName() + ": " + String.valueOf(e)));
            }
            LOGGER.error((Object)(SetupHelper.class.getSimpleName() + ": Simulation database abandoned."));
            return SimulationState.TERMINATED_STATE;
        }
        return new SimulationState(netInstances, restoreSource);
    }

    private static void clearDatabase(Connection connection, SQLDialect dialect) throws SQLException {
        Entity.deleteEntities(new TokenPositionEntity(connection, dialect));
        Entity.deleteEntities(new TokenEntity(connection, dialect));
        Entity.deleteEntities(new NetInstanceEntity(connection, dialect));
    }

    public static class SimulationState {
        public static final SimulationState TERMINATED_STATE = new SimulationState(Collections.emptyList(), null);
        private final List<NetInstance> NET_INSTANCES;
        private boolean _wasSimulationInitedFlag;
        private boolean _wasSimulationRunningFlag;

        private SimulationState(List<NetInstance> netInstances, RestoreSource source) {
            this.NET_INSTANCES = netInstances;
            try {
                this._wasSimulationInitedFlag = source != null && source.wasSimulationInited();
                this._wasSimulationRunningFlag = source != null && source.wasSimulationRunning();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Cannot determine simulation run state:");
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                this._wasSimulationInitedFlag = false;
                this._wasSimulationRunningFlag = false;
            }
        }

        public List<NetInstance> getNetInstances() {
            return this.NET_INSTANCES;
        }

        public boolean wasSimulationInited() {
            return this._wasSimulationInitedFlag;
        }

        public boolean wasSimulationRunning() {
            return this._wasSimulationRunningFlag;
        }
    }
}

