/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.thread;

import de.renew.engine.thread.SimulationThread;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.util.Semaphor;
import java.util.concurrent.Callable;

class BlockingSimulationCallable<T>
implements Callable<T> {
    private final Callable<T> _task;
    private final Semaphor _notifier;
    private Thread _ancestor;

    BlockingSimulationCallable(Callable<T> taskToRun, Semaphor lock, Thread ancestor) {
        this._task = taskToRun;
        this._notifier = lock;
        this._ancestor = ancestor;
    }

    Thread getAncestor() {
        return this._ancestor;
    }

    @Override
    public T call() throws Exception {
        T returnValue;
        try {
            if (SimulationThreadPool.getLogger().isTraceEnabled()) {
                SimulationThreadPool.getLogger().trace((Object)("Executing simulation callable now:          " + String.valueOf(this._task) + " in " + String.valueOf(Thread.currentThread())));
            }
            returnValue = this._task.call();
        }
        finally {
            this.abort((SimulationThread)Thread.currentThread());
        }
        return returnValue;
    }

    void abort(SimulationThread t) {
        this._notifier.V();
        this._ancestor = null;
        if (t != null) {
            t.setAncestor(null);
        }
    }
}

