/*
 * Decompiled with CFR 0.152.
 */
package de.renew.expression;

import de.renew.expression.Expression;
import de.renew.expression.ExpressionWithTypeField;
import de.renew.expression.Function;
import de.renew.expression.VariableMapper;
import de.renew.unify.ICalculationChecker;
import de.renew.unify.IStateRecorder;
import de.renew.unify.Impossible;
import de.renew.unify.Notifiable;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.Types;

public class InvertibleExpression
extends ExpressionWithTypeField {
    private final Expression _argument;
    private final Function _forwardFunction;
    private final Function _backwardFunction;

    public InvertibleExpression(Class<?> targetType, Expression argument, Function forwardFunction, Function backwardFunction) {
        super(targetType);
        this._argument = argument;
        this._forwardFunction = forwardFunction;
        this._backwardFunction = backwardFunction;
    }

    @Override
    public boolean isInvertible() {
        return this._argument.isInvertible();
    }

    public Expression getArgument() {
        return this._argument;
    }

    @Override
    public Object startEvaluation(VariableMapper mapper, IStateRecorder recorder, ICalculationChecker checker) throws Impossible {
        final Variable source = new Variable(this._argument.startEvaluation(mapper, recorder, checker), recorder);
        final Variable target = new Variable();
        if (checker != null) {
            checker.addEarlyVariable(source, recorder);
        }
        Notifiable sourceListener = new Notifiable(){

            @Override
            public void boundNotify(IStateRecorder irecorder) throws Impossible {
                if (Unify.isBound(source)) {
                    Unify.unify(target, InvertibleExpression.this._forwardFunction.function(source.getValue()), irecorder);
                }
            }
        };
        source.addListener(sourceListener, recorder);
        Notifiable targetListener = new Notifiable(){

            @Override
            public void boundNotify(IStateRecorder irecorder) throws Impossible {
                if (Unify.isBound(target)) {
                    Unify.unify(source, InvertibleExpression.this._backwardFunction.function(target.getValue()), irecorder);
                }
            }
        };
        target.addListener(targetListener, recorder);
        return target.getValue();
    }

    @Override
    public Object registerCalculation(VariableMapper mapper, IStateRecorder recorder, ICalculationChecker checker) throws Impossible {
        Variable source = new Variable(this._argument.registerCalculation(mapper, recorder, checker), recorder);
        Variable target = new Variable();
        checker.addLateVariable(source, recorder);
        checker.addCalculated(this.getType(), target, source.getValue(), recorder);
        return target.getValue();
    }

    public String toString() {
        return "InvertibleExpr(" + Types.typeToString((Class)this.getType()) + ": " + String.valueOf(this._forwardFunction) + ", " + String.valueOf(this._backwardFunction) + ", " + String.valueOf(this._argument) + ")";
    }
}

