/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.util.AWTSynchronizedUpdate;
import CH.ifa.draw.util.Fontkit;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.searchqueue.TimeListener;
import de.renew.gui.CPNSimulation;
import de.renew.remote.BindingAccessor;
import de.renew.remote.RemoteTriggerable;
import de.renew.remote.TransitionInstanceAccessor;
import de.renew.remote.TriggerableForwarder;
import de.renew.remote.TriggerableForwarderImpl;
import de.renew.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

class BindingSelectionFrame
implements ListSelectionListener,
TimeListener,
RemoteTriggerable {
    private static final Logger logger = Logger.getLogger(BindingSelectionFrame.class);
    private static BindingSelectionFrame instance = null;
    private final JFrame frame;
    private final JTextArea currentElement;
    private final JList<String> bindingList;
    private final DefaultListModel<String> bindingListModel;
    private final JButton fireButton;
    private BindingAccessor[] bindings;
    private String[] fullBindingText;
    private TransitionInstanceAccessor transitionInstance;
    private CPNSimulation simulation;
    private TriggerableForwarder triggerableForwarder;
    private boolean inSearch = false;
    private boolean wantClose = false;
    private final Object updateSynchronizer = new Object();
    private static boolean frameOpened = false;

    private BindingSelectionFrame() {
        this.frame = new JFrame();
        this.currentElement = new JTextArea(5, 20);
        this.currentElement.setEditable(false);
        this.currentElement.setFont((Font)Fontkit.getFont((String)"Monospaced", (int)0, (int)11));
        JScrollPane currentElementPane = new JScrollPane(this.currentElement);
        currentElementPane.setMinimumSize(new Dimension(150, 50));
        currentElementPane.setPreferredSize(new Dimension(250, 100));
        this.bindingListModel = new DefaultListModel();
        this.bindingList = new JList<String>(this.bindingListModel);
        this.bindingList.setSelectionMode(0);
        this.bindingList.addListSelectionListener(this);
        this.bindingList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    int i = BindingSelectionFrame.this.bindingList.getSelectedIndex();
                    BindingSelectionFrame.this.fireBinding(i);
                }
            }
        });
        this.bindingList.setVisibleRowCount(10);
        JScrollPane bindingListPane = new JScrollPane(this.bindingList);
        bindingListPane.setMinimumSize(new Dimension(100, 50));
        bindingListPane.setPreferredSize(new Dimension(150, 100));
        JSplitPane splitPane = new JSplitPane(1, bindingListPane, currentElementPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.1);
        this.frame.getContentPane().add((Component)splitPane, "Center");
        this.fireButton = new JButton(" Fire ");
        this.fireButton.addActionListener(event -> {
            int index = this.bindingList.getSelectedIndex();
            this.fireBinding(index);
        });
        JButton updateButton = new JButton(" Update ");
        updateButton.addActionListener(e -> this.update());
        JButton closeButton = new JButton(" Close ");
        closeButton.addActionListener(e -> BindingSelectionFrame.close());
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.fireButton);
        buttonPanel.add(updateButton);
        buttonPanel.add(closeButton);
        this.frame.getContentPane().add((Component)buttonPanel, "South");
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BindingSelectionFrame.close();
            }
        });
        this.frame.pack();
        SearchQueue.insertTimeListener((TimeListener)this);
        try {
            this.triggerableForwarder = new TriggerableForwarderImpl((RemoteTriggerable)this);
        }
        catch (RemoteException e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            JOptionPane.showMessageDialog(this.frame, "A problem occurred: " + String.valueOf(e2) + "\nSee the console for details.", "Binding selection frame", 0);
        }
    }

    static synchronized void open(TransitionInstanceAccessor transitionInstance, CPNSimulation simulation) {
        if (instance == null) {
            instance = new BindingSelectionFrame();
        }
        frameOpened = true;
        instance.setup(transitionInstance, simulation);
    }

    static synchronized void close() {
        if (instance != null) {
            instance.instanceClose();
        }
    }

    private synchronized void instanceClose() {
        if (this.inSearch) {
            this.wantClose = true;
        } else {
            this.closeNow();
        }
    }

    private void closeNow() {
        assert (this.triggerableForwarder != null) : "Triggerable forwarder should have the same lifespan as the frame.";
        if (this.transitionInstance != null) {
            try {
                this.transitionInstance.forgetBindings(this.triggerableForwarder);
            }
            catch (RemoteException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                JOptionPane.showMessageDialog(this.frame, "Could not disconnect from transition instance:\n" + String.valueOf(e) + "\nSee the console for details.", "Binding selection frame", 2);
            }
        }
        this.frame.setVisible(false);
        frameOpened = false;
        this.bindingListModel.clear();
        this.transitionInstance = null;
        this.wantClose = false;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        String text = "";
        int index = this.bindingList.getSelectedIndex();
        if (index >= 0 && index < this.bindings.length) {
            text = this.fullBindingText[index];
        }
        this.currentElement.setText(text);
        this.currentElement.setCaretPosition(0);
    }

    private void fireBinding(int index) {
        if (index >= 0 && index < this.bindings.length) {
            this.simulation.getBreakpointManager().clearLog();
            try {
                this.bindings[index].execute(!this.simulation.isStrictlySequential());
            }
            catch (RemoteException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                JOptionPane.showMessageDialog(this.frame, "A problem occurred: " + String.valueOf(e) + "\nSee the console for details.", "Binding selection frame", 0);
            }
            this.simulation.simulationRefresh();
            this.update();
        } else {
            this.fireButton.setEnabled(false);
        }
    }

    private void setup(TransitionInstanceAccessor transitionInstance, CPNSimulation simulation) {
        this.transitionInstance = transitionInstance;
        this.wantClose = false;
        this.simulation = simulation;
        try {
            this.frame.setTitle(transitionInstance.asString() + "'s possible bindings");
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            JOptionPane.showMessageDialog(this.frame, "A problem occurred: " + String.valueOf(e) + "\nSee the console for details.", "Binding selection frame", 0);
        }
        this.update();
    }

    public void proposeSearch() {
        this.update();
    }

    public void timeAdvanced() {
        this.update();
    }

    public void update() {
        new AWTSynchronizedUpdate((Runnable)new BindingListUpdater()).scheduleUpdate();
    }

    private void setActiveBindings(BindingAccessor[] localBindings, String[] fullBindings, String[] shortBindings) {
        this.bindings = localBindings;
        this.fullBindingText = fullBindings;
        this.bindingListModel.clear();
        for (String shortBinding : shortBindings) {
            this.bindingListModel.addElement(shortBinding);
        }
        String text = "";
        if (this.bindings.length > 0) {
            this.bindingList.setSelectedIndex(0);
            text = this.fullBindingText[0];
        }
        this.currentElement.setText(text);
        this.currentElement.setCaretPosition(0);
        this.fireButton.setEnabled(this.bindings.length > 0);
    }

    private class BindingListUpdater
    extends Thread {
        private BindingListUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean dirty = false;
            Object object = BindingSelectionFrame.this.updateSynchronizer;
            synchronized (object) {
                if (BindingSelectionFrame.this.inSearch) {
                    dirty = true;
                    return;
                }
                if (BindingSelectionFrame.this.wantClose) {
                    BindingSelectionFrame.this.closeNow();
                    return;
                }
                dirty = false;
                BindingSelectionFrame.this.inSearch = true;
            }
            while (true) {
                if (BindingSelectionFrame.this.transitionInstance != null) {
                    this.update();
                }
                object = BindingSelectionFrame.this.updateSynchronizer;
                synchronized (object) {
                    if (BindingSelectionFrame.this.wantClose) {
                        BindingSelectionFrame.this.closeNow();
                        dirty = false;
                    }
                    if (!dirty) {
                        BindingSelectionFrame.this.inSearch = false;
                        return;
                    }
                    dirty = false;
                }
            }
        }

        public void update() {
            BindingAccessor[] localBindings;
            try {
                localBindings = BindingSelectionFrame.this.transitionInstance.findAllBindings(BindingSelectionFrame.this.triggerableForwarder);
            }
            catch (RemoteException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
            String[] fullBinding = new String[localBindings.length];
            String[] shortBinding = new String[localBindings.length];
            for (int i = 0; i < localBindings.length; ++i) {
                try {
                    fullBinding[i] = localBindings[i].getDescription();
                }
                catch (RemoteException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    fullBinding[i] = e.toString();
                }
                shortBinding[i] = StringUtil.unspace((String)fullBinding[i]);
                if (shortBinding[i].length() <= 50) continue;
                shortBinding[i] = shortBinding[i].substring(0, 47) + "...";
            }
            EventQueue.invokeLater(() -> {
                BindingSelectionFrame.this.setActiveBindings(localBindings, fullBinding, shortBinding);
                if (frameOpened) {
                    BindingSelectionFrame.this.frame.setVisible(true);
                }
            });
        }
    }
}

