/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.gui.ActionJList;
import de.renew.gui.CPNApplication;
import de.renew.gui.GuiPlugin;
import de.renew.plugin.command.CLCommand;
import de.renew.simulator.api.SimulationManager;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class Demonstrator
implements CLCommand {
    private static final Logger logger = Logger.getLogger(Demonstrator.class);
    private static JFrame frame = null;
    private static JList<String> list = null;
    private static DefaultListModel<String> listModel = null;

    public String getDescription() {
        return "opens a window with a list of drawing file names";
    }

    public String getArguments() {
        return "fileNames";
    }

    public void execute(String[] args, PrintStream response) {
        response.println("The Renew demonstration GUI");
        if (args.length == 0) {
            response.println("Usage: demonstrator files...");
            response.println("or     demonstrator -conffile");
        } else if (args[0].startsWith("-")) {
            try {
                FileReader fileReader = new FileReader(args[0].substring(1));
                BufferedReader reader = new BufferedReader(fileReader);
                ArrayList<String> names = new ArrayList<String>();
                while (reader.ready()) {
                    String name = reader.readLine();
                    if (name == null || name.isEmpty()) continue;
                    names.add(name);
                }
                String[] arr = names.toArray(new String[0]);
                Demonstrator.setup(arr);
                reader.close();
            }
            catch (Exception e) {
                response.println("Error: could not access configuration file.");
                logger.error((Object)"Could not access configuration file.", (Throwable)e);
            }
        } else {
            Demonstrator.setup(args);
        }
    }

    public static synchronized void setup(String[] args) {
        if (frame == null) {
            frame = new JFrame("Demonstration Drawings");
            frame.setSize(600, 200);
            GridBagLayout gridBag = new GridBagLayout();
            frame.getContentPane().setLayout(gridBag);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 0;
            listModel = new DefaultListModel();
            list = new JList<String>(listModel);
            list.addMouseListener(new ActionJList(list));
            gridBag.setConstraints(list, c);
            frame.getContentPane().add(list);
            JPanel panel = new JPanel();
            c.fill = 2;
            c.weighty = 0.0;
            gridBag.setConstraints(panel, c);
            frame.getContentPane().add(panel);
            gridBag = new GridBagLayout();
            panel.setLayout(gridBag);
            c = new GridBagConstraints();
            c.weightx = 1.0;
            c.fill = 1;
            c.gridwidth = 1;
            JButton button = new JButton("Replace");
            button.addActionListener(e -> Demonstrator.replaceDrawings());
            gridBag.setConstraints(button, c);
            panel.add(button);
            button = new JButton("Include");
            button.addActionListener(e -> Demonstrator.openDrawings());
            gridBag.setConstraints(button, c);
            panel.add(button);
            button = new JButton("Exit");
            button.addActionListener(e -> {
                GuiPlugin.getCurrent().closeGui();
                frame.setVisible(false);
            });
            gridBag.setConstraints(button, c);
            panel.add(button);
        }
        listModel.removeAllElements();
        for (String arg : args) {
            listModel.addElement(arg);
        }
        EventQueue.invokeLater(() -> frame.setVisible(true));
    }

    static synchronized void replaceDrawings() {
        int i;
        CPNApplication app = GuiPlugin.getCurrent().getGui();
        if (app == null) {
            GuiPlugin.getCurrent().openGui();
            app = GuiPlugin.getCurrent().getGui();
        }
        if ((i = list.getSelectedIndex()) >= 0 && i < listModel.size()) {
            SimulationManager.terminateSimulation();
            app.cleanupSimulationWindows();
            Enumeration enumeration = app.drawings();
            while (enumeration.hasMoreElements()) {
                Drawing drawing = (Drawing)enumeration.nextElement();
                app.closeDrawing(drawing);
            }
        }
        Demonstrator.openDrawings();
    }

    private static synchronized void openDrawings() {
        int i;
        CPNApplication app = GuiPlugin.getCurrent().getGui();
        if (app == null) {
            GuiPlugin.getCurrent().openGui();
            app = GuiPlugin.getCurrent().getGui();
        }
        if ((i = list.getSelectedIndex()) >= 0 && i < listModel.size()) {
            StringTokenizer tokenizer = new StringTokenizer(listModel.elementAt(i), ",", false);
            ArrayList<String> tokens = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                tokens.add(tokenizer.nextToken());
            }
            app.loadAndOpenCommandLineDrawings(tokens.toArray(new String[0]));
        }
    }

    public static synchronized void cleanup() {
        if (frame != null) {
            JFrame finalFrame = frame;
            EventQueue.invokeLater(() -> {
                finalFrame.setVisible(false);
                finalFrame.dispose();
            });
        }
        frame = null;
        list = null;
        listModel = null;
    }
}

