/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.util.Command;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.gui.CPNDrawing;
import de.renew.gui.FigureWithHighlight;
import java.util.Vector;

public class HighlightSelectCommand
extends Command {
    public HighlightSelectCommand(String name) {
        super(name);
    }

    protected DrawingEditor getEditor() {
        return EditorApi.getCurrentEditor();
    }

    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        Drawing drawing = this.getEditor().drawing();
        DrawingView view = this.getEditor().view();
        if (drawing instanceof CPNDrawing) {
            if (view.selectionCount() == 1) {
                return view.selectionElements().nextFigure() instanceof FigureWithHighlight;
            }
            return view.selectionCount() > 1;
        }
        return false;
    }

    public void execute() {
        if (this.isExecutable()) {
            DrawingView view = this.getEditor().view();
            FigureEnumeration figenumeration = view.selectionElements();
            Vector<Figure> highlights = new Vector<Figure>();
            while (figenumeration.hasMoreElements()) {
                Figure hilight;
                Figure fig = figenumeration.nextFigure();
                if (!(fig instanceof FigureWithHighlight) || (hilight = ((FigureWithHighlight)fig).getHighlightFigure()) == null) continue;
                highlights.addElement(hilight);
            }
            if (highlights.isEmpty()) {
                this.getEditor().showStatus("Select some nodes (places or transitions) with highlight figures.");
            } else {
                view.clearSelection();
                view.addToSelectionAll(highlights);
                view.repairDamage();
                this.getEditor().showStatus("Highlight(s) selected!");
            }
        }
    }
}

