/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.converter;

import java.awt.Color;
import java.util.StringTokenizer;

public class GraphicConverter {
    private static GraphicConverter _instance;

    protected GraphicConverter() {
    }

    public static GraphicConverter instance() {
        if (_instance == null) {
            _instance = new GraphicConverter();
        }
        return _instance;
    }

    public String parseRenewLineStyle(String style) {
        if ("10".equals(style)) {
            return "dash";
        }
        if ("1 2".equals(style)) {
            return "dot";
        }
        return "solid";
    }

    public String parsePNMLLineStyle(String style) {
        if ("dash".equals(style)) {
            return "10";
        }
        if ("dot".equals(style)) {
            return "1 2";
        }
        return "";
    }

    public Color parseCSS2Color(String color) {
        StringTokenizer tokenizer;
        Color result = null;
        if (color.equalsIgnoreCase("aqua")) {
            result = new Color(0, 255, 255);
        } else if (color.equalsIgnoreCase("black")) {
            result = new Color(0, 0, 0);
        } else if (color.equalsIgnoreCase("blue")) {
            result = new Color(0, 0, 255);
        } else if (color.equalsIgnoreCase("fuchsia")) {
            result = new Color(255, 0, 255);
        } else if (color.equalsIgnoreCase("gray")) {
            result = new Color(128, 128, 128);
        } else if (color.equalsIgnoreCase("green")) {
            result = new Color(0, 128, 0);
        } else if (color.equalsIgnoreCase("lime")) {
            result = new Color(0, 255, 0);
        } else if (color.equalsIgnoreCase("maroon")) {
            result = new Color(128, 0, 0);
        } else if (color.equalsIgnoreCase("navy")) {
            result = new Color(0, 0, 128);
        } else if (color.equalsIgnoreCase("olive")) {
            result = new Color(128, 128, 0);
        } else if (color.equalsIgnoreCase("purple")) {
            result = new Color(128, 0, 128);
        } else if (color.equalsIgnoreCase("red")) {
            result = new Color(255, 0, 0);
        } else if (color.equalsIgnoreCase("silver")) {
            result = new Color(192, 192, 192);
        } else if (color.equalsIgnoreCase("teal")) {
            result = new Color(0, 128, 128);
        } else if (color.equalsIgnoreCase("white")) {
            result = new Color(255, 255, 255);
        } else if (color.equalsIgnoreCase("yellow")) {
            result = new Color(255, 255, 0);
        } else if (color.startsWith("#")) {
            if ((color = color.substring(1)).length() == 3) {
                char[] string = new char[]{color.charAt(0), color.charAt(0), color.charAt(1), color.charAt(1), color.charAt(2), color.charAt(2)};
                color = new String(string);
            }
            int r = Integer.parseInt(color.substring(0, 2), 16);
            int g = Integer.parseInt(color.substring(2, 4), 16);
            int b = Integer.parseInt(color.substring(4, 6), 16);
            result = new Color(r, g, b);
        } else if (color.startsWith("rgb(") && (tokenizer = new StringTokenizer(color = color.substring(4, color.length() - 1), ",")).countTokens() == 3) {
            int r = Integer.parseInt(tokenizer.nextToken());
            int g = Integer.parseInt(tokenizer.nextToken());
            int b = Integer.parseInt(tokenizer.nextToken());
            result = new Color(r, g, b);
        }
        if (result == null) {
            throw new IllegalArgumentException();
        }
        return result;
    }
}

