/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.creator;

import CH.ifa.draw.framework.FigureWithID;
import de.renew.gui.ArcConnection;
import de.renew.gui.VirtualPlaceFigure;
import de.renew.gui.VirtualTransitionFigure;
import de.renew.gui.pnml.converter.Converter;
import de.renew.gui.pnml.creator.AttributeCreator;
import de.renew.gui.pnml.creator.GraphicCreator;
import de.renew.gui.pnml.creator.ObjectCreator;
import de.renew.gui.pnml.creator.PNMLCreator;
import java.awt.Color;
import java.awt.Point;
import org.w3c.dom.Element;

public class ArcCreator
extends ObjectCreator {
    private VirtualPlaceFigure virPlaceStart = null;
    private VirtualPlaceFigure virPlaceEnd = null;
    private VirtualTransitionFigure virTransitionStart = null;
    private VirtualTransitionFigure virTransitionEnd = null;

    public ArcCreator(Converter converter) {
        super("arc", converter);
    }

    public void setVirStart(VirtualPlaceFigure vir) {
        this.virPlaceStart = vir;
    }

    public void setVirEnd(VirtualPlaceFigure vir) {
        this.virPlaceEnd = vir;
    }

    public void setVirStart(VirtualTransitionFigure vir) {
        this.virTransitionStart = vir;
    }

    public void setVirEnd(VirtualTransitionFigure vir) {
        this.virTransitionEnd = vir;
    }

    protected ArcConnection getArc() {
        return (ArcConnection)this.getFigure();
    }

    @Override
    protected void doCreateAttribute(PNMLCreator pnmlCreator, Element element) {
        String attributeValue;
        switch (this.getArc().getArcType()) {
            case 2: {
                attributeValue = "both";
                break;
            }
            case 3: {
                attributeValue = "inhibitor";
                break;
            }
            case 0: {
                attributeValue = "test";
                break;
            }
            case 5: {
                attributeValue = "clear";
                break;
            }
            case 4: {
                attributeValue = "multi-ordinary";
                break;
            }
            default: {
                return;
            }
        }
        AttributeCreator creator = new AttributeCreator(pnmlCreator, "type");
        element.appendChild(creator.createElement(attributeValue));
    }

    @Override
    protected void doCreateGraphic(GraphicCreator creator) {
        int count = this.getArc().pointCount();
        for (int pos = 1; pos < count - 1; ++pos) {
            Point p = this.getArc().pointAt(pos);
            creator.addPosition(p.x, p.y);
        }
        Color c = (Color)this.getFigure().getAttribute("FrameColor");
        creator.addLineColor(c);
        String s = (String)this.getFigure().getAttribute("LineStyle");
        creator.addLineStyle(s);
        creator.addLine();
    }

    @Override
    protected void doCreateObject(PNMLCreator pnmlCreator, Element element) {
        FigureWithID source = (FigureWithID)this.getArc().startFigure();
        FigureWithID target = (FigureWithID)this.getArc().endFigure();
        element.setAttribute("source", this.xmlID(source));
        element.setAttribute("target", this.xmlID(target));
        if (this.virPlaceStart != null || this.virPlaceEnd != null || this.virTransitionStart != null || this.virTransitionEnd != null) {
            Element toolSpecific = pnmlCreator.createToolspecific();
            if (this.virPlaceStart != null) {
                toolSpecific.setAttribute("source", this.xmlID(this.virPlaceStart));
            }
            if (this.virPlaceEnd != null) {
                toolSpecific.setAttribute("target", this.xmlID(this.virPlaceEnd));
            }
            if (this.virTransitionStart != null) {
                toolSpecific.setAttribute("source", this.xmlID(this.virTransitionStart));
            }
            if (this.virTransitionEnd != null) {
                toolSpecific.setAttribute("target", this.xmlID(this.virTransitionEnd));
            }
            element.appendChild(toolSpecific);
        }
    }
}

