/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import de.renew.gui.pnml.converter.NetConverter;
import de.renew.gui.pnml.parser.ObjectParser;
import java.awt.Color;
import java.awt.Point;
import org.w3c.dom.Element;

public abstract class NodeParser
extends ObjectParser {
    public NodeParser(Element node, NetConverter converter) {
        super(node, converter);
    }

    private Point getLocation() {
        if (this.getGraphic().hasPosition()) {
            return this.getGraphic().positions().next();
        }
        return new Point();
    }

    @Override
    protected void initGraphic() {
        Color fillColor = this.getGraphic().getFill();
        Color lineColor = this.getGraphic().getLineColor();
        Point location = this.getLocation();
        Point topLeft = new Point(0, 0);
        Point bottomRight = this.getGraphic().getDimension();
        if (bottomRight == null) {
            bottomRight = new Point(20, 20);
        }
        if (fillColor != null) {
            this.figure().setAttribute("FillColor", (Object)fillColor);
        }
        if (lineColor != null) {
            this.figure().setAttribute("FrameColor", (Object)lineColor);
        }
        this.figure().displayBox(topLeft, bottomRight);
        this.moveObject(location.x - bottomRight.x / 2, location.y - bottomRight.y / 2);
    }
}

