/*
 * Decompiled with CFR 0.152.
 */
package de.renew.export.io.exportcli;

import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.util.GUIProperties;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.exporting.AbstractDrawingExportFormat;
import de.renew.export.io.exportFormats.EPSExportFormat;
import de.renew.export.io.exportFormats.PDFExportFormat;
import de.renew.export.io.exportFormats.PNGExportFormat;
import de.renew.export.io.exportFormats.SVGExportFormat;
import de.renew.ioontology.exporting.ExportFormat;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class Export {
    public static List<ExportFormat<Drawing>> _exportFormats = Arrays.asList(new ExportFormat[]{new PDFExportFormat(), new PNGExportFormat(), new EPSExportFormat()});

    public static void main(String[] args) throws Exception {
        PluginManager.configureLogging();
        GUIProperties.setProperties((Properties)PluginProperties.getUserProperties());
        if (args.length >= 2) {
            File outFile;
            File dir;
            String inFileName = args[0];
            Object outFileName = args[1];
            File inFile = new File(inFileName);
            Drawing netDrawing = DrawingFileHelper.loadDrawing((File)inFile, System.out::println);
            Object exportFormat = Export.guessExportFormat((String)outFileName);
            if (exportFormat == null) {
                exportFormat = new PDFExportFormat();
                outFileName = (String)outFileName + ".pdf";
            }
            if ((dir = (outFile = new File((String)outFileName)).getParentFile()) != null && !dir.exists()) {
                System.out.println("Creating directory " + String.valueOf(dir) + " because it does not exist.");
                outFile.getParentFile().mkdirs();
            }
            System.out.println("Exporting " + inFile.getAbsolutePath() + " to " + outFile.getAbsolutePath() + ".");
            exportFormat.export((Object)netDrawing, outFile);
        }
    }

    private static ExportFormat<Drawing> guessExportFormat(String outFileName) {
        String extension = Export.getFileExtension(outFileName);
        AbstractDrawingExportFormat format = null;
        switch (extension.toLowerCase()) {
            case "pdf": {
                format = new PDFExportFormat();
                break;
            }
            case "eps": {
                format = new EPSExportFormat();
                break;
            }
            case "png": {
                format = new PNGExportFormat();
                break;
            }
            case "svg": {
                format = new SVGExportFormat();
            }
        }
        return format;
    }

    private static String getFileExtension(String fileName) {
        String extension = "";
        int i = fileName.lastIndexOf(46);
        if (i > 0) {
            extension = fileName.substring(i + 1);
        }
        return extension;
    }
}

