/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator.api;

import de.renew.plugin.ServiceLookupException;
import de.renew.plugin.ServiceLookupInfrastructure;
import de.renew.simulator.api.ISimulationLockExecutor;
import java.util.function.Supplier;
import org.apache.log4j.Logger;

public final class SimulationLockExecutor {
    private static final ISimulationLockExecutor EXECUTOR;
    private static final Logger LOGGER;

    private SimulationLockExecutor() {
    }

    public static void lock() {
        EXECUTOR.lock();
    }

    public static void unlock() {
        EXECUTOR.unlock();
    }

    public static void runWithLock(Runnable runnable) {
        EXECUTOR.runWithLock(runnable);
    }

    public static <T> T supplyWithLock(Supplier<T> supplier) {
        return EXECUTOR.supplyWithLock(supplier);
    }

    static {
        LOGGER = Logger.getLogger(SimulationLockExecutor.class);
        try {
            EXECUTOR = (ISimulationLockExecutor)ServiceLookupInfrastructure.getInstance().getFirstServiceProvider(ISimulationLockExecutor.class);
        }
        catch (ServiceLookupException e) {
            LOGGER.error((Object)("Could not find a service provider for " + String.valueOf(ISimulationLockExecutor.class) + ": "), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

