/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator.api;

import de.renew.plugin.ServiceLookupException;
import de.renew.plugin.ServiceLookupInfrastructure;
import de.renew.simulator.api.ISimulationManager;
import de.renew.simulatorontology.shadow.ShadowNetSystem;
import de.renew.simulatorontology.shadow.SyntaxException;
import de.renew.simulatorontology.simulation.NoSimulationException;
import de.renew.simulatorontology.simulation.SimulationEnvironment;
import de.renew.simulatorontology.simulation.Simulator;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class SimulationManager {
    private static final Logger LOGGER = Logger.getLogger(SimulationManager.class);
    private static final ISimulationManager SIMULATION_MANAGER;

    private SimulationManager() {
    }

    public static void setupSimulation(Properties properties) {
        SIMULATION_MANAGER.setupSimulation(properties);
    }

    public static void addShadowNetSystem(ShadowNetSystem shadowNetSystem) throws SyntaxException, NoSimulationException {
        SIMULATION_MANAGER.addShadowNetSystem(shadowNetSystem);
    }

    public static Simulator getCurrentSimulator() {
        return SIMULATION_MANAGER.getCurrentSimulator();
    }

    public static Properties getSimulationProperties() {
        return SIMULATION_MANAGER.getSimulationProperties();
    }

    public static SimulationEnvironment getCurrentEnvironment() {
        return SIMULATION_MANAGER.getCurrentEnvironment();
    }

    public static void terminateSimulation() {
        SIMULATION_MANAGER.terminateSimulation();
    }

    public static boolean isSimulationActive() {
        return SIMULATION_MANAGER.isSimulationActive();
    }

    public static void setDefaultNetLoader() {
        SIMULATION_MANAGER.setDefaultNetLoader();
    }

    static {
        try {
            SIMULATION_MANAGER = (ISimulationManager)ServiceLookupInfrastructure.getInstance().getFirstServiceProvider(ISimulationManager.class);
        }
        catch (ServiceLookupException e) {
            LOGGER.error((Object)("Could not find a service provider for " + String.valueOf(ISimulationManager.class) + ": "), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

