/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.function;

import de.renew.expression.Function;
import de.renew.formalism.function.Executor;
import de.renew.unify.Impossible;
import de.renew.unify.Tuple;
import de.renew.util.ReflectionSerializer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class StaticMethodFunction
implements Function {
    private static final Logger LOGGER = Logger.getLogger(StaticMethodFunction.class);
    transient Method _method;

    public StaticMethodFunction(Method method) {
        if ((method.getModifiers() & 8) == 0) {
            throw new RuntimeException("Method expected to be static.");
        }
        this._method = method;
    }

    public Object function(Object param) throws Impossible {
        Tuple args = (Tuple)param;
        Object[] paramArr = new Object[args.getArity()];
        for (int i = 0; i < paramArr.length; ++i) {
            paramArr[i] = args.getComponent(i);
        }
        try {
            return Executor.executeMethod(this._method, null, paramArr);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable targetException = ((InvocationTargetException)e).getTargetException();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error((Object)targetException.getMessage(), targetException);
                    LOGGER.error((Object)("while executing " + String.valueOf(this._method) + "."));
                }
                throw new Impossible("Method call resulted in an exception: " + String.valueOf(targetException), targetException);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                LOGGER.error((Object)("while executing " + String.valueOf(this._method) + "."));
            }
            throw new Impossible("Exception occured during method call: " + String.valueOf(e), (Throwable)e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ReflectionSerializer.writeMethod((ObjectOutputStream)out, (Method)this._method);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._method = ReflectionSerializer.readMethod((ObjectInputStream)in);
    }
}

