/*
 * Decompiled with CFR 0.152.
 */
package de.renew.propertymanagementgui.gui;

import de.renew.propertymanagementgui.gui.CloseButtonComponent;
import de.renew.propertymanagementgui.gui.SaveButtonComponent;
import de.renew.propertymanagementgui.reactivecomponents.Component;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class FooterComponent
extends Component {
    private static final String SAVE_LOCALLY = "Save locally";
    private static final String SAVE_GLOBALLY = "Save globally";
    private static final int RIGID_AREA_WIDTH = 10;
    private static final int RIGID_AREA_HEIGHT = 0;
    private static final EmptyBorder ACTION_BUTTONS_WRAPPER_BORDER = new EmptyBorder(5, 5, 5, 5);
    private final Runnable _savePropertiesGlobalAction;
    private final Runnable _savePropertiesLocalAction;

    public FooterComponent(Runnable savePropertiesGlobalAction, Runnable savePropertiesLocalAction) {
        this._savePropertiesGlobalAction = savePropertiesGlobalAction;
        this._savePropertiesLocalAction = savePropertiesLocalAction;
    }

    @Override
    protected JComponent render() {
        JPanel footer = new JPanel();
        this.setLayoutForFooter(footer);
        JComponent actionButtonsWrapper = this.getActionButtonsWrapperIn();
        footer.add((java.awt.Component)actionButtonsWrapper, "East");
        return footer;
    }

    private void setLayoutForFooter(JComponent footer) {
        footer.setMaximumSize(new Dimension(Integer.MAX_VALUE, footer.getPreferredSize().height));
        footer.setLayout(new BorderLayout());
    }

    private JComponent getActionButtonsWrapperIn() {
        JPanel actionButtonsWrapper = new JPanel();
        this.setLayoutForActionButtonsWrapper(actionButtonsWrapper);
        this.addActionButtonsToActionButtonsWrapper(actionButtonsWrapper);
        return actionButtonsWrapper;
    }

    private void setLayoutForActionButtonsWrapper(JComponent actionButtonsWrapper) {
        actionButtonsWrapper.setLayout(new BoxLayout(actionButtonsWrapper, 0));
        actionButtonsWrapper.setBorder(ACTION_BUTTONS_WRAPPER_BORDER);
    }

    private void addActionButtonsToActionButtonsWrapper(JComponent actionButtonsWrapper) {
        SaveButtonComponent saveButtonLocal = new SaveButtonComponent(this._savePropertiesLocalAction, SAVE_LOCALLY);
        SaveButtonComponent saveButtonGlobal = new SaveButtonComponent(this._savePropertiesGlobalAction, SAVE_GLOBALLY);
        actionButtonsWrapper.add(saveButtonLocal.get());
        actionButtonsWrapper.add(saveButtonGlobal.get());
        actionButtonsWrapper.add(Box.createRigidArea(new Dimension(10, 0)));
        CloseButtonComponent closeButton = new CloseButtonComponent(e -> {
            Window window = SwingUtilities.getWindowAncestor(actionButtonsWrapper);
            if (window != null) {
                window.dispose();
            }
        });
        actionButtonsWrapper.add(closeButton.get());
    }
}

