/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.locate;

import de.renew.plugin.CollectionLister;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.locate.PluginLocationFinder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class PluginFileFinder
implements PluginLocationFinder {
    public static final Logger LOGGER = Logger.getLogger(PluginFileFinder.class);
    private URL _pluginBase;

    public PluginFileFinder(URL basedir) {
        if (basedir == null) {
            try {
                basedir = new File(System.getProperty("user.dir")).toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)"PluginFileFinder: now, that IS strange.");
            }
        }
        this._pluginBase = basedir;
    }

    protected URL getPluginBase() {
        return this._pluginBase;
    }

    public String toString() {
        return "a PluginFileFinder looking below " + String.valueOf(this._pluginBase);
    }

    @Override
    public Collection<PluginProperties> findPluginLocations() {
        Collection<PluginProperties> urls = new Vector<PluginProperties>();
        try {
            URL url = this.getPluginBase();
            LOGGER.debug((Object)(this.getClass().getName() + ": plugin base is " + url.toExternalForm()));
            File dir = this.convert(url, true);
            if (dir == null) {
                return new Vector<PluginProperties>();
            }
            if (!dir.exists()) {
                LOGGER.error((Object)("plugin directory " + String.valueOf(dir) + " not found."));
                return new Vector<PluginProperties>();
            }
            if (!dir.isDirectory()) {
                return new Vector<PluginProperties>();
            }
            File[] plugins = this.getPluginFiles(dir);
            urls = this.getPluginConfigurations(plugins);
            LOGGER.debug((Object)(urls.size() + " plugin locations found."));
            LOGGER.debug((Object)CollectionLister.toString(urls));
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"something went wrong looking for a plugin location.");
        }
        return urls;
    }

    @Override
    public PluginProperties checkPluginLocation(URL url) {
        URL resolved;
        if (url == null || !"file".equals(url.getProtocol())) {
            return null;
        }
        try {
            resolved = new URL(this._pluginBase, url.getPath());
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)("PluginFileFinder: Strange URL \"" + String.valueOf(url) + "\": " + String.valueOf(e)), (Throwable)e);
            resolved = url;
        }
        File asFile = this.convert(resolved, false);
        if (asFile != null) {
            Collection<PluginProperties> coll;
            if (asFile.isFile() && asFile.getName().contains("plugin.cfg")) {
                asFile = asFile.getParentFile();
            }
            if (!(coll = this.getPluginConfigurations(new File[]{asFile})).isEmpty()) {
                return coll.iterator().next();
            }
        }
        return null;
    }

    private File convert(URL url, boolean verbose) {
        File asFile = null;
        try {
            asFile = new File(new URI(url.toExternalForm()));
        }
        catch (URISyntaxException e) {
            if (verbose) {
                LOGGER.error((Object)("PluginFileFinder: Strange URL \"" + String.valueOf(url) + "\": " + String.valueOf(e)), (Throwable)e);
            }
            LOGGER.debug((Object)("PluginFileFinder: Strange URL \"" + String.valueOf(url) + "\": " + String.valueOf(e)), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            if (verbose) {
                LOGGER.error((Object)("PluginFileFinder: Not a file? URL \"" + String.valueOf(url) + "\": " + e.getMessage()), (Throwable)e);
            }
            LOGGER.debug((Object)("PluginFileFinder: Not a file? URL \"" + String.valueOf(url) + "\": " + e.getMessage()), (Throwable)e);
        }
        catch (NullPointerException e) {
            if (verbose) {
                LOGGER.error((Object)("PluginFileFinder: " + String.valueOf(e)), (Throwable)e);
            }
            LOGGER.debug((Object)("PluginFileFinder: " + String.valueOf(e)), (Throwable)e);
        }
        return asFile;
    }

    protected abstract File[] getPluginFiles(File var1);

    protected abstract Collection<PluginProperties> getPluginConfigurations(File[] var1);

    @Override
    public PluginProperties findPluginByProvides(String provides) {
        Collection<PluginProperties> pluginLocations = this.findPluginLocations();
        for (PluginProperties pluginProperties : pluginLocations) {
            if (!pluginProperties.getProvisions().contains(provides)) continue;
            return pluginProperties;
        }
        return null;
    }

    @Override
    public PluginProperties findPluginByName(String pluginName) {
        Collection<PluginProperties> pluginLocations = this.findPluginLocations();
        for (PluginProperties pluginProperties : pluginLocations) {
            if (!pluginProperties.getName().equals(pluginName)) continue;
            return pluginProperties;
        }
        return null;
    }

    @Override
    public Collection<URL> getLocations() {
        ArrayList<URL> location = new ArrayList<URL>();
        location.add(this._pluginBase);
        return location;
    }
}

