/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.PieFigure;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import de.renew.draw.ui.ontology.DrawingView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.freehep.graphicsio.VectorGraphicsIO;

@Deprecated(since="5.0", forRemoval=true)
class PieAngleHandle
extends AbstractHandle {
    private double _angle;
    private final PieFigure _pieFig;
    private final int _angleKind;

    public PieAngleHandle(PieFigure owner, int angleKind) {
        super(owner);
        this._pieFig = owner;
        this._angleKind = angleKind;
    }

    @Override
    public void invokeStart(int x, int y, DrawingView view) {
        super.invokeStart(x, y, view);
        this._angle = this._pieFig.getAngle(this._angleKind);
    }

    @Override
    public void invokeStep(MouseEvent e, int x, int y, int anchorX, int anchorY, DrawingView view) {
        Rectangle r = this._pieFig.displayBox();
        Point from = new Point(x, y);
        Point center = new Point(r.x + r.width / 2, r.y + r.height / 2);
        double angleRad = from.equals(center) ? Math.PI : Geom.pointToAngle(r, from);
        this._angle = PieFigure.normalizeAngle(-Math.toDegrees(angleRad));
        if (e.isControlDown()) {
            this._angle = Math.round(this._angle / 15.0) * 15L % 360L;
        }
        this._pieFig.setAngle(this._angleKind, this._angle);
    }

    @Override
    public Point locate() {
        Rectangle r = this._pieFig.displayBox();
        this._angle = this._pieFig.getAngle(this._angleKind);
        double angleRad = -Math.toRadians(this._angle);
        return Geom.ovalAngleToPoint(r, angleRad);
    }

    @Override
    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.yellow);
        if (g instanceof VectorGraphicsIO) {
            g.fillOval(r.x + 1, r.y + 1, r.width - 1, r.height - 1);
        } else {
            g.fillOval(r.x, r.y, r.width, r.height);
        }
        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }
}

