/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.standard.FilteredFigureEnumerator;
import CH.ifa.draw.util.Geom;
import de.renew.draw.storables.ontology.ConnectionFigure;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.FigureFilter;
import de.renew.draw.ui.ontology.DrawingView;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

@Deprecated
public class SpreadCommand
extends UndoableCommand {
    public static final int LEFTS = 0;
    public static final int CENTERS = 1;
    public static final int RIGHTS = 2;
    public static final int TOPS = 3;
    public static final int MIDDLES = 4;
    public static final int BOTTOMS = 5;
    public static final int HORIZONTAL_DISTANCE = 6;
    public static final int VERTICAL_DISTANCE = 7;
    public static final int DIAGONAL_CENTERS = 8;
    private static final int DIAGONAL_DISTANCE = 9;
    private final int _op;

    @Deprecated
    public SpreadCommand(String name, int op) {
        super(name);
        this._op = op;
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 2;
    }

    @Override
    public boolean executeUndoable() {
        if (this.isExecutable()) {
            Iterator sortedIter;
            if (!super.isExecutable()) {
                return false;
            }
            DrawingView view = this.getEditor().view();
            FigureEnumeration selection = view.selectionElements();
            selection = new FilteredFigureEnumerator(selection, new ConnectionFilter());
            LinkedList<SortPair> sortedList = new LinkedList<SortPair>();
            Rectangle bBox = null;
            while (selection.hasMoreElements()) {
                SortPair currentFigurePair = new SortPair(this._op, selection.nextFigure());
                if (bBox == null) {
                    bBox = new Rectangle(currentFigurePair._hotspot);
                } else {
                    bBox.add(currentFigurePair._hotspot);
                }
                sortedList.add(0, currentFigurePair);
            }
            if (sortedList.size() < 3) {
                return false;
            }
            if (this._op != 8 && this._op != 9) {
                sortedList.sort(new HotspotComparator(this._op));
            } else {
                SortPair firstPair;
                Point bBoxCenter = Geom.center(bBox);
                sortedList.sort(new DistanceComparator(bBoxCenter));
                sortedIter = sortedList.iterator();
                SortPair secondPair = firstPair = (SortPair)sortedIter.next();
                SortPair currentPair = firstPair;
                int minDistance = Math.max(bBox.width, bBox.height) / 2;
                long minDistance2 = (long)minDistance * (long)minDistance;
                long foundDistance2 = 0L;
                while (sortedIter.hasNext() && currentPair.distance2(bBoxCenter) >= minDistance2) {
                    currentPair = (SortPair)sortedIter.next();
                    long currentDistance2 = currentPair.distance2(firstPair._hotspot);
                    if (foundDistance2 >= currentDistance2) continue;
                    foundDistance2 = currentDistance2;
                    secondPair = currentPair;
                }
                sortedList.sort(new ProjectionComparator(firstPair._hotspot, secondPair._hotspot));
            }
            int wholeLengthX = 0;
            int wholeLengthY = 0;
            int firstIndex = 0;
            int lastIndex = sortedList.size() - 1;
            sortedIter = sortedList.iterator();
            switch (this._op) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    wholeLengthX = ((SortPair)sortedList.get((int)lastIndex))._hotspot.x - ((SortPair)sortedList.get((int)firstIndex))._hotspot.x;
                    wholeLengthY = ((SortPair)sortedList.get((int)lastIndex))._hotspot.y - ((SortPair)sortedList.get((int)firstIndex))._hotspot.y;
                    break;
                }
                case 6: 
                case 7: {
                    Rectangle currentBox;
                    Rectangle prevBox = ((SortPair)sortedIter.next())._figure.displayBox();
                    while (sortedIter.hasNext()) {
                        currentBox = ((SortPair)sortedIter.next())._figure.displayBox();
                        wholeLengthX += currentBox.x - prevBox.x - prevBox.width;
                        wholeLengthY += currentBox.y - prevBox.y - prevBox.height;
                        prevBox = currentBox;
                    }
                    break;
                }
                case 9: {
                    Rectangle currentBox;
                    wholeLengthX = ((SortPair)sortedList.get((int)lastIndex))._hotspot.x - ((SortPair)sortedList.get((int)firstIndex))._hotspot.x;
                    wholeLengthY = ((SortPair)sortedList.get((int)lastIndex))._hotspot.y - ((SortPair)sortedList.get((int)firstIndex))._hotspot.y;
                    Rectangle prevBox = ((SortPair)sortedIter.next())._figure.displayBox();
                    while (sortedIter.hasNext()) {
                        currentBox = ((SortPair)sortedIter.next())._figure.displayBox();
                        wholeLengthX -= prevBox.width;
                        wholeLengthY -= prevBox.height;
                        prevBox = currentBox;
                    }
                    break;
                }
            }
            Point shouldSpot = null;
            Point firstSpot = ((SortPair)sortedList.get((int)0))._hotspot;
            int nodeCount = 0;
            int intervals = sortedList.size() - 1;
            SortPair prevFigurePair = null;
            for (SortPair currentFigurePair : sortedList) {
                switch (this._op) {
                    case 0: 
                    case 1: 
                    case 2: {
                        shouldSpot = new Point(firstSpot.x + wholeLengthX * nodeCount / intervals, currentFigurePair._hotspot.y);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        shouldSpot = new Point(currentFigurePair._hotspot.x, firstSpot.y + wholeLengthY * nodeCount / intervals);
                        break;
                    }
                    case 8: {
                        shouldSpot = new Point(firstSpot.x + wholeLengthX * nodeCount / intervals, firstSpot.y + wholeLengthY * nodeCount / intervals);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 9: {
                        if (prevFigurePair != null) {
                            int distanceToAddX = wholeLengthX * nodeCount / intervals - wholeLengthX * (nodeCount - 1) / intervals;
                            int distanceToAddY = wholeLengthY * nodeCount / intervals - wholeLengthY * (nodeCount - 1) / intervals;
                            shouldSpot = switch (this._op) {
                                case 6 -> new Point(prevFigurePair._hotspot.x + prevFigurePair._figure.displayBox().width + distanceToAddX, currentFigurePair._hotspot.y);
                                case 7 -> new Point(currentFigurePair._hotspot.x, prevFigurePair._hotspot.y + prevFigurePair._figure.displayBox().height + distanceToAddY);
                                case 9 -> new Point(prevFigurePair._hotspot.x + (wholeLengthX >= 0 ? prevFigurePair._figure.displayBox().width : currentFigurePair._figure.displayBox().width) + distanceToAddX, prevFigurePair._hotspot.y + (wholeLengthY >= 0 ? prevFigurePair._figure.displayBox().height : currentFigurePair._figure.displayBox().height) + distanceToAddY);
                                default -> shouldSpot;
                            };
                            break;
                        }
                        shouldSpot = currentFigurePair._hotspot;
                    }
                }
                if (shouldSpot != null) {
                    currentFigurePair._figure.moveBy(shouldSpot.x - currentFigurePair._hotspot.x, shouldSpot.y - currentFigurePair._hotspot.y);
                    prevFigurePair = new SortPair(this._op, currentFigurePair._figure);
                }
                ++nodeCount;
            }
            view.checkDamage();
            return true;
        }
        return false;
    }

    private static class ConnectionFilter
    implements FigureFilter {
        private ConnectionFilter() {
        }

        @Override
        public boolean isAcceptedFigure(Figure figure) {
            return !(figure instanceof ConnectionFigure);
        }
    }

    private static class SortPair {
        public final Figure _figure;
        public final Point _hotspot;

        public SortPair(int op, Figure figure) {
            Point newHotspot = switch (op) {
                case 0, 3, 6, 7 -> figure.displayBox().getLocation();
                case 2, 5 -> new Point(figure.displayBox().x + figure.displayBox().width, figure.displayBox().y + figure.displayBox().height);
                case 1, 4, 8 -> Geom.center(figure.displayBox());
                default -> null;
            };
            this._figure = figure;
            this._hotspot = newHotspot;
        }

        public long distance2(Point origin) {
            return Geom.length2(origin.x, origin.y, this._hotspot.x, this._hotspot.y);
        }
    }

    private static class HotspotComparator
    implements Comparator<SortPair> {
        private final int _op;

        public HotspotComparator(int op) {
            this._op = op;
        }

        @Override
        public int compare(SortPair fst, SortPair snd) {
            return switch (this._op) {
                case 0, 1, 2, 6 -> fst._hotspot.x - snd._hotspot.x;
                case 3, 4, 5, 7 -> fst._hotspot.y - snd._hotspot.y;
                default -> throw new RuntimeException("SpreadCommand: Comparator: Illegal operation mode " + this._op + "!");
            };
        }
    }

    private static class DistanceComparator
    implements Comparator<SortPair> {
        private final Point _origin;

        public DistanceComparator(Point origin) {
            this._origin = origin;
        }

        @Override
        public int compare(SortPair fst, SortPair snd) {
            long difference = snd.distance2(this._origin) - fst.distance2(this._origin);
            if (difference < 0L) {
                return -1;
            }
            if (difference > 0L) {
                return 1;
            }
            return 0;
        }
    }

    private static class ProjectionComparator
    implements Comparator<SortPair> {
        private final float _xL;
        private final float _yL;
        private final float _denominator;

        public ProjectionComparator(Point origin, Point second) throws ArithmeticException {
            float distance = (float)Math.sqrt(Geom.length2(origin.x, origin.y, second.x, second.y));
            if (distance == 0.0f) {
                throw new ArithmeticException("Projection line end points are too near!");
            }
            this._xL = (float)(second.x - origin.x) / distance;
            this._yL = (float)(second.y - origin.y) / distance;
            this._denominator = this._xL * this._xL + this._yL * this._yL;
        }

        @Override
        public int compare(SortPair fst, SortPair snd) {
            float i1 = (float)fst._hotspot.x * this._xL + (float)fst._hotspot.y * this._yL / this._denominator;
            float i2 = (float)snd._hotspot.x * this._xL + (float)snd._hotspot.y * this._yL / this._denominator;
            return Float.compare(i1, i2);
        }
    }
}

