/*
 * Decompiled with CFR 0.152.
 */
package de.renew.draw.ui.api;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.DrawingListener;
import de.renew.draw.ui.api.services.EditorService;
import de.renew.draw.ui.impl.services.EditorServiceImpl;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.DrawingView;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

public final class EditorApi {
    private static EditorService _service = new EditorServiceImpl();

    public static void loadAndOpenDrawings(URL url) {
        _service.loadAndOpenDrawings(url);
    }

    private EditorApi() {
    }

    public static void loadAndOpenDrawings(InputStream stream, String fileName) throws IOException {
        _service.loadAndOpenDrawings(stream, fileName);
    }

    public static void openOrLoadDrawing(File file) {
        _service.openOrLoadDrawing(file);
    }

    public static void checkDamage() {
        _service.checkDamage();
    }

    public static void repairDamage() {
        _service.repairDamage();
    }

    public static void toolDone() {
        _service.toolDone();
    }

    public static void addMouseListener(MouseListener mouseListener) {
        _service.addMouseListener(mouseListener);
    }

    public static void removeMouseListener(MouseListener mouseListener) {
        _service.removeMouseListener(mouseListener);
    }

    public static DrawingEditor getCurrentEditor() {
        return _service.getCurrentEditor();
    }

    public static DrawingEditor getNullDrawingEditor() {
        return _service.getNullDrawingEditor();
    }

    public static DrawingView getNullDrawingView() {
        return _service.getNullDrawingView();
    }

    public static Drawing getCurrentDrawing() {
        return _service.getCurrentDrawing();
    }

    public static Enumeration<Drawing> getCurrentDrawings() {
        return _service.getCurrentDrawings();
    }

    public static Drawing openDrawing(Drawing drawing) {
        return _service.openDrawing(drawing);
    }

    public static void openDrawing(Drawing drawing, Point point, Dimension dimension) {
        _service.openDrawing(drawing, point, dimension);
    }

    public static void closeDrawing(Drawing drawing) {
        _service.closeDrawing(drawing);
    }

    public static void addDrawingListener(DrawingListener listener) {
        _service.addDrawingListener(listener);
    }

    public static void removeDrawingListener(DrawingListener listener) {
        _service.removeDrawingListener(listener);
    }
}

