/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ioontology.importing;

import de.renew.ioontology.FileFilter;
import de.renew.ioontology.importing.ImportFormat;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Objects;

public abstract class ImportFormatAbstract<T>
implements ImportFormat<T> {
    private String _formatName;
    private FileFilter _fileFilter;

    public ImportFormatAbstract(String name, FileFilter fileFilter) {
        this.setFormatName(name);
        this.setFileFilter(fileFilter);
    }

    private void setFileFilter(FileFilter fileFilter) {
        this._fileFilter = fileFilter;
        Objects.requireNonNull(this.fileFilter(), "Failure in ImportFormatAbstract: fileFilter() == null");
    }

    private void setFormatName(String formatName) {
        this._formatName = formatName;
        Objects.requireNonNull(this.formatName(), "Failure in ImportFormatAbstract: formatName() == null");
    }

    @Override
    public FileFilter fileFilter() {
        return this._fileFilter;
    }

    @Override
    public String formatName() {
        return this._formatName;
    }

    @Override
    public boolean canImport(URL path) {
        return this.fileFilter().accept(new File(path.getFile()));
    }

    @Override
    public boolean canImport(URI path) {
        return this.fileFilter().accept(new File(path.getPath()));
    }

    public String toString() {
        return this.formatName();
    }
}

