/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.PlaceInstance;
import de.renew.net.TimeSet;
import de.renew.remote.MarkingAccessor;
import de.renew.remote.ObjectAccessor;
import de.renew.remote.ObjectAccessorImpl;
import de.renew.remote.SocketFactoryDeterminer;
import de.renew.simulatorontology.simulation.SimulationEnvironment;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.Callable;

public class MarkingAccessorImpl
extends UnicastRemoteObject
implements MarkingAccessor {
    private SimulationEnvironment _environment;
    private double _currentTime;
    private int _distinctTokenCount;
    private int _freeTokenCount;
    private int _testedTokenCount;
    private int[] _tokenFreeCounts;
    private ObjectAccessor[] _tokens;
    private String[] _tokenStrings;
    private boolean[] _tokenTesteds;
    private double[][] _tokenTimeArrays;
    private int[][] _tokenTimeMultiplicitiesArrays;

    public MarkingAccessorImpl(final PlaceInstance placeInstance, SimulationEnvironment env) throws RemoteException {
        super(0, SocketFactoryDeterminer.getInstance(), SocketFactoryDeterminer.getInstance());
        this._environment = env;
        SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                Vector tokenVector = new Vector();
                placeInstance._lock.lock();
                try {
                    Iterator iterator = placeInstance.getDistinctTestableTokens().iterator();
                    while (iterator.hasNext()) {
                        tokenVector.addElement(iterator.next());
                    }
                    MarkingAccessorImpl.this._distinctTokenCount = tokenVector.size();
                    MarkingAccessorImpl.this._tokenFreeCounts = new int[MarkingAccessorImpl.this._distinctTokenCount];
                    MarkingAccessorImpl.this._tokens = new ObjectAccessor[MarkingAccessorImpl.this._distinctTokenCount];
                    MarkingAccessorImpl.this._tokenStrings = new String[MarkingAccessorImpl.this._distinctTokenCount];
                    MarkingAccessorImpl.this._tokenTesteds = new boolean[MarkingAccessorImpl.this._distinctTokenCount];
                    MarkingAccessorImpl.this._tokenTimeArrays = new double[MarkingAccessorImpl.this._distinctTokenCount][];
                    MarkingAccessorImpl.this._tokenTimeMultiplicitiesArrays = new int[MarkingAccessorImpl.this._distinctTokenCount][];
                    MarkingAccessorImpl.this._currentTime = SearchQueue.getTime();
                    MarkingAccessorImpl.this._freeTokenCount = 0;
                    MarkingAccessorImpl.this._testedTokenCount = 0;
                    for (int i = 0; i < MarkingAccessorImpl.this._distinctTokenCount; ++i) {
                        TimeSet timeSet;
                        Object token = tokenVector.elementAt(i);
                        MarkingAccessorImpl.this._tokens[i] = ObjectAccessorImpl.createObjectAccessor(token, MarkingAccessorImpl.this._environment);
                        MarkingAccessorImpl.this._tokenStrings[i] = token == null ? "null" : token.toString();
                        TimeSet extendedTimeSet = timeSet = placeInstance.getFreeTimeSet(token);
                        if (placeInstance.containsTestedToken(token)) {
                            MarkingAccessorImpl.this._tokenTesteds[i] = true;
                            ++MarkingAccessorImpl.this._testedTokenCount;
                            extendedTimeSet = timeSet.including(MarkingAccessorImpl.this._currentTime);
                        } else {
                            MarkingAccessorImpl.this._tokenTesteds[i] = false;
                        }
                        MarkingAccessorImpl.this._tokenFreeCounts[i] = placeInstance.getTokenCount(token);
                        MarkingAccessorImpl.this._freeTokenCount += MarkingAccessorImpl.this._tokenFreeCounts[i];
                        MarkingAccessorImpl.this._tokenTimeArrays[i] = extendedTimeSet.asUniqueArray();
                        MarkingAccessorImpl.this._tokenTimeMultiplicitiesArrays[i] = new int[MarkingAccessorImpl.this._tokenTimeArrays[i].length];
                        for (int j = 0; j < MarkingAccessorImpl.this._tokenTimeMultiplicitiesArrays[i].length; ++j) {
                            MarkingAccessorImpl.this._tokenTimeMultiplicitiesArrays[i][j] = timeSet.multiplicity(MarkingAccessorImpl.this._tokenTimeArrays[i][j]);
                        }
                    }
                }
                finally {
                    placeInstance._lock.unlock();
                }
                return null;
            }
        });
    }

    @Override
    public int getDistinctTokenCount() throws RemoteException {
        return this._distinctTokenCount;
    }

    @Override
    public int getFreeTokenCount() throws RemoteException {
        return this._freeTokenCount;
    }

    @Override
    public int getTestedTokenCount() throws RemoteException {
        return this._testedTokenCount;
    }

    @Override
    public String[] getAllTokenStrings() throws RemoteException {
        return this._tokenStrings;
    }

    @Override
    public int[] getAllTokenFreeCounts() throws RemoteException {
        return this._tokenFreeCounts;
    }

    @Override
    public boolean[] getAllTokenTested() throws RemoteException {
        return this._tokenTesteds;
    }

    @Override
    public int getTokenFreeCount(int i) throws RemoteException {
        return this._tokenFreeCounts[i];
    }

    @Override
    public boolean getTokenTested(int i) throws RemoteException {
        return this._tokenTesteds[i];
    }

    @Override
    public String getTokenString(int i) throws RemoteException {
        return this._tokenStrings[i];
    }

    @Override
    public double[] getTokenTimes(int i) throws RemoteException {
        return this._tokenTimeArrays[i];
    }

    @Override
    public int[] getTokenTimeMultiplicities(int i) throws RemoteException {
        return this._tokenTimeMultiplicitiesArrays[i];
    }

    @Override
    public ObjectAccessor getToken(int i) throws RemoteException {
        return this._tokens[i];
    }

    @Override
    public double getCurrentTime() throws RemoteException {
        return this._currentTime;
    }

    @Override
    public boolean removeOneOf(int i) throws RemoteException {
        throw new RuntimeException("Not yet implemented");
    }
}

