/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HashedRelation<K, V>
implements Serializable {
    private final Map<K, Set<V>> _map = new HashMap<K, Set<V>>();

    public synchronized void put(K key, V elem) {
        Set<Object> set;
        if (this._map.containsKey(key)) {
            set = this._map.get(key);
        } else {
            set = new HashSet();
            this._map.put(key, set);
        }
        set.add(elem);
    }

    public synchronized void remove(K key, V elem) {
        Set<V> set = this._map.get(key);
        set.remove(elem);
        if (set.isEmpty()) {
            this._map.remove(key);
        }
    }

    public synchronized Set<K> keys() {
        return this._map.keySet();
    }

    public synchronized Set<V> elementsAt(K key) {
        return this._map.getOrDefault(key, Collections.emptySet());
    }

    public synchronized int sizeAt(Object key) {
        if (this._map.containsKey(key)) {
            Set<V> set = this._map.get(key);
            return set.size();
        }
        return 0;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("de.renew.util.HashedRelation( ");
        for (K key : this._map.keySet()) {
            buffer.append(key);
            buffer.append(" -> (");
            boolean first = true;
            for (V value : this._map.get(key)) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(value);
            }
            buffer.append(") ");
        }
        buffer.append(")");
        return buffer.toString();
    }
}

