/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

public class RandomBag {
    private Object[] _elements = new Object[8];
    private int _size = 0;

    public int size() {
        return this._size;
    }

    private void setCapacity(int capacity) {
        Object[] newElements = new Object[capacity];
        System.arraycopy(this._elements, 0, newElements, 0, this._size);
        this._elements = newElements;
    }

    private void ensureCapacity(int capacity) {
        if (capacity > this._elements.length) {
            if (capacity < 2 * this._elements.length) {
                capacity = 2 * this._elements.length;
            }
            this.setCapacity(capacity);
        }
    }

    private void limitCapacity() {
        if (this._size >= 8 && this._size * 4 < this._elements.length) {
            this.setCapacity(this._size * 2);
        }
    }

    public void insert(Object elem) {
        this.ensureCapacity(this._size + 1);
        this._elements[this._size++] = elem;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public Object extract() {
        if (this.isEmpty()) {
            return null;
        }
        Object elem = this._elements[this._size - 1];
        this._elements[this._size - 1] = null;
        --this._size;
        this.limitCapacity();
        return elem;
    }
}

