/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import java.util.LinkedList;

public class RunQueue
implements Runnable {
    private final LinkedList<Runnable> _runnables = new LinkedList();
    private boolean _terminated = false;

    public boolean isTerminated() {
        return this._terminated;
    }

    public synchronized void add(Runnable runnable) {
        if (!this._terminated) {
            this._runnables.addFirst(runnable);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this._terminated) {
            RunQueue runQueue = this;
            synchronized (runQueue) {
                if (Thread.currentThread().isInterrupted()) {
                    this._terminated = true;
                } else if (this._runnables.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        this._terminated = true;
                    }
                } else {
                    Runnable runnable = this._runnables.removeLast();
                    runnable.run();
                }
            }
        }
    }
}

