/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.util.Iconkit;
import java.awt.Image;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public abstract class NavigatorAction
extends AbstractAction {
    public NavigatorAction(String tooltip, String iconIdentifier, KeyStroke keyStroke) {
        super(null, NavigatorAction.loadIcon(iconIdentifier));
        this.putValue("ShortDescription", tooltip);
        if (keyStroke != null && DrawPlugin.getGui() != null) {
            JRootPane rootPane = DrawPlugin.getGui().getFrame().getRootPane();
            rootPane.getInputMap(2).put(keyStroke, tooltip);
            rootPane.getActionMap().put(tooltip, this);
        }
    }

    private static ImageIcon loadIcon(String iconIdentifier) {
        Image icon = Iconkit.instance().loadImage(iconIdentifier);
        Image scaled = icon.getScaledInstance(-1, 16, 4);
        return new ImageIcon(scaled);
    }

    public String getActionName() {
        String simpleName = this.getClass().getSimpleName();
        simpleName = simpleName.replaceAll("([A-Z])", " $1").trim();
        return simpleName.replace(" Action", "");
    }

    protected void error(String message) {
        JOptionPane.showMessageDialog(null, message, String.format("%s failed", this.getActionName()), 0);
    }
}

