/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator;

import CH.ifa.draw.IOHelper;
import CH.ifa.draw.io.ImportHolder;
import CH.ifa.draw.util.CommandMenuItem;
import de.renew.draw.ui.api.MenuApi;
import de.renew.draw.ui.ontology.AbstractCommand;
import de.renew.draw.ui.ontology.MenuSectionPosition;
import de.renew.navigator.AutosaveController;
import de.renew.navigator.FilesystemController;
import de.renew.navigator.NavigatorExtender;
import de.renew.navigator.NavigatorExtension;
import de.renew.navigator.NavigatorGui;
import de.renew.navigator.OpenNavigatorCommand;
import de.renew.navigator.gui.NavigatorGuiProxy;
import de.renew.navigator.io.FileFilterBuilderImpl;
import de.renew.navigator.models.NavigatorFileTree;
import de.renew.plugin.PluginManager;
import de.renew.plugin.annotations.Inject;
import de.renew.plugin.annotations.Provides;
import de.renew.plugin.command.CLCommand;
import de.renew.plugin.di.DIPlugin;
import de.renew.windowmanagement.Workbench;
import java.awt.Toolkit;
import javax.swing.JMenuItem;
import javax.swing.JTree;

public final class NavigatorPlugin
extends DIPlugin
implements NavigatorExtender {
    private static final String OPEN_NAVIGATOR_COMMAND_MENU_ID = "de.renew.navigator.show";
    private final NavigatorFileTree _model = new NavigatorFileTree();
    private final AutosaveController _autoSave;
    private final FilesystemController _fileSystem;
    private final NavigatorGui _gui;
    private JMenuItem _openNavigatorItem;

    @Inject
    public NavigatorPlugin(ImportHolder importHolder, IOHelper ioHelper, Workbench workbench) {
        this.initMenu();
        FileFilterBuilderImpl builder = new FileFilterBuilderImpl(ioHelper, importHolder);
        this._autoSave = new AutosaveController(this);
        this._fileSystem = new FilesystemController(this, builder);
        this._gui = new NavigatorGuiProxy(this._fileSystem, workbench, this);
    }

    @Override
    @Provides
    public NavigatorFileTree getModel() {
        return this._model;
    }

    @Provides
    public NavigatorGui getGui() {
        return this._gui;
    }

    public void init() {
        PluginManager pluginManager = PluginManager.getInstance();
        if (pluginManager != null) {
            pluginManager.addCLCommand("navigator", (CLCommand)new OpenNavigatorCommand(this));
        }
        this.initControllers();
    }

    private void initMenu() {
        this._openNavigatorItem = new CommandMenuItem((AbstractCommand)new OpenNavigatorCommand(this), 78, 0x40 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        this._openNavigatorItem.putClientProperty("ch.ifa.draw.menu.id", OPEN_NAVIGATOR_COMMAND_MENU_ID);
        MenuApi.registerMenu((String)"File", (JMenuItem)this._openNavigatorItem, (int)2, (MenuSectionPosition)MenuSectionPosition.BEGINNING);
    }

    public boolean cleanup() {
        PluginManager pluginManager;
        if (this._openNavigatorItem != null) {
            MenuApi.unregisterMenu((JMenuItem)this._openNavigatorItem);
            this._openNavigatorItem = null;
        }
        if ((pluginManager = PluginManager.getInstance()) != null) {
            pluginManager.removeCLCommand("navigator");
        }
        return true;
    }

    @Override
    public void registerExtension(NavigatorExtension extension) {
        this._gui.addExtension(extension);
    }

    @Override
    public boolean deregisterExtension(NavigatorExtension extension) {
        return this._gui.removeExtension(extension);
    }

    @Override
    public JTree getTree() {
        return this._gui.getTree();
    }

    public void openNavigator() {
        if (this._autoSave.isAutosaveFileExisting()) {
            this._autoSave.loadModel();
        }
        this._gui.openWindow();
    }

    private void initControllers() {
        this._model.addObserver(this._autoSave);
        this._model.addObserver(this._fileSystem);
    }

    @Deprecated
    public void openInNavigator() {
        this.openNavigator();
    }

    @Deprecated
    public static NavigatorPlugin getCurrent() {
        return (NavigatorPlugin)PluginManager.getInstance().getPluginByName("Navigator");
    }
}

