/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.gui;

import de.renew.navigator.NavigatorAction;
import de.renew.navigator.gui.NavigatorGuiImpl;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.KeyStroke;

class TreeKeyListener
implements KeyListener {
    private NavigatorGuiImpl _gui = null;

    public TreeKeyListener(NavigatorGuiImpl navGUI) {
        this._gui = navGUI;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 0) {
            return;
        }
        if (this.checkActionAccelerators(e)) {
            return;
        }
        switch (e.getKeyCode()) {
            case 10: 
            case 30: {
                this._gui.openSelected();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private boolean checkActionAccelerators(KeyEvent e) {
        for (NavigatorAction action : this._gui.getActions()) {
            boolean ctrlOk;
            KeyStroke stroke = (KeyStroke)action.getValue("AcceleratorKey");
            if (stroke == null) continue;
            boolean shiftOk = (1 & stroke.getModifiers()) == 0 || e.isShiftDown();
            boolean bl = ctrlOk = (2 & stroke.getModifiers()) == 0 || e.isControlDown();
            if (stroke.getKeyCode() != e.getKeyCode() || !shiftOk || !ctrlOk) continue;
            action.actionPerformed(null);
            return true;
        }
        return false;
    }
}

